/*******************************************************************************
 * Copyright (c) 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.internal;

import java.io.File;
import java.util.Properties;
import java.util.UUID;

import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Platform;
import org.simantics.db.ServerEx;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.LifecycleSupport;
import org.simantics.db.service.XSupport;
import org.simantics.project.management.ServerManager;
import org.simantics.project.management.ServerManagerFactory;

/**
 * An as-simple-as-possible utility class for starting a Simantics database
 * instance and opening a connection ({@link Session}) to it.
 *
 * <p>
 * To get up and running, simply invoke:
 * <pre>
 *     SessionUtil util = new SessionUtil("my-client-id");
 *     try {
 *         File workspaceLocation = ...;
 *         Session session = util.openSession(workspaceLocation);
 *         // do something with the database session
 *     } finally {
 *         util.close();
 *     }
 * </pre>
 *
 * <p>
 * This class is a provisional utility, pending for public inclusion.
 *
 * @author Tuukka Lehtonen
 * @see Session
 */
public class SessionUtil {

	private String clientId;
	@SuppressWarnings("unused")
	private File workspace;

	private ServerManager serverManager;
	private ServerEx server;
	private Session session;

	public static String getApplicationClientId() {
		IProduct product = Platform.getProduct();
		if(product == null) return "noProduct";
		String application = product.getApplication();
		return application != null ? application : UUID.randomUUID().toString();
	}

	public SessionUtil() {
		this(UUID.randomUUID().toString());
	}

	public SessionUtil(String clientId) {
		serverManager = ServerManagerFactory.getServerManager();
		this.clientId = clientId;
	}

	public void close() throws DatabaseException {
		if (session != null) {
			session.getService(LifecycleSupport.class).close();
		}
		serverManager.close();
	}

//	public Session open(File workspace) throws IOException, DatabaseException {
//		File dbDir = new File(workspace, "db");
//		if (!dbDir.exists() || !dbDir.isDirectory())
//			throw new FileNotFoundException("database directory " + dbDir + " not found");
//		server = serverManager.getServer(dbDir);
//		server.start(null);
//		session = openSession(server, dbDir);
//		this.workspace = workspace;
//		return session;
//	}

	private Session openSession(ServerEx server, File dbDir) throws DatabaseException {
		Properties info = new Properties(ServerManager.DEFAULT);
		session = server.createSession(info);
		session.getService(XSupport.class).setServiceMode(true, true);
		return session;
	}

}
