/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.Command;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.osgi.service.prefs.BackingStoreException;
import org.simantics.simulation.ui.preferences.SimulationPreferenceUtil;
import org.simantics.simulation.ui.preferences.SimulationPreferences;
import org.simantics.utils.ui.ExceptionUtils;
import org.simantics.utils.ui.validators.DoubleValidator;

public class SetDuration extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        SimulationPreferences prefs = SimulationPreferenceUtil.getPrefs();

        InputDialog dialog = new InputDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(),
                "Set Simulation Step Duration", "Simulation step duration in seconds", "" + prefs.stepDuration, new DoubleValidator());
        if (dialog.open() == InputDialog.OK) {
            final double duration = Double.parseDouble(dialog.getValue());
            try {
                SimulationPreferenceUtil.flushPrefs(new SimulationPreferences(duration));
            } catch (BackingStoreException e) {
                ExceptionUtils.logAndShowError(e);
            }

            // Update tool-tip for Step command
            ICommandService service = (ICommandService) PlatformUI.getWorkbench().getService(ICommandService.class); 
            Command command = service.getCommand("org.simantics.simulation.ui.step");
            service.refreshElements(command.getId(), null); 

//            IExperimentManager manager = SimanticsUI.getProject2().getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
//            IExperiment experiment = manager.getActiveExperiment();
//            if (experiment instanceof IDynamicExperiment)
//                ((IDynamicExperiment) experiment).simulateDuration(duration);
        }

        return null;
    }

}
