/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.request.ReadRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.IProject;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.ErrorLogger;

/**
 * A generic command handler for activating an experiment based on the currently
 * selected experiment in the UI.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see ActivateExperimentAction
 * @see ExperimentActivator
 */
public class ActivateExperimentHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection(event);
        final Resource experiment = ResourceAdaptionUtils.toSingleResource(selection);
        if (experiment == null)
            return null;

        final IProject project = SimanticsUI.peekProject();
        if (project == null)
            return null;

        final IExperimentManager experimentManager = project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
        if (experimentManager == null) {
            ErrorLogger.defaultLogWarning("Experiment manager not available.", new Exception());
            return null;
        }

        try {
            project.getSession().syncRequest(new ReadRequest() {
                @Override
                public void run(ReadGraph graph) throws DatabaseException {
                    if (graph.isInstanceOf(experiment, SimulationResource.getInstance(graph).Experiment)) {
                        ExperimentActivator.scheduleActivation(graph, project, experimentManager, experiment);
                    }
                }
            });
        } catch (DatabaseException e) {
            ErrorLogger.defaultLogError(e);
        }

        return null;
    }

}