/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.ui.handlers;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.project.IProject;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.simulation.project.IExperimentManager;
import org.simantics.ui.DoubleClickEvent;
import org.simantics.ui.IDoubleClickAction;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;
import org.simantics.utils.ui.action.PriorityAction;

/**
 * A double click action handler for the graph explorer browser. Intended for
 * invocation when an experiment resource is double clicked, which is controlled
 * from outside of this class.
 * 
 * @author Tuukka Lehtonen
 * 
 * @see ExperimentActivator
 */
public class ActivateExperimentAction implements IDoubleClickAction {

    @Override
    public void doubleClickEvent(DoubleClickEvent e) throws DatabaseException {
        ReadGraph g = e.getGraph();
        final Resource experiment = ResourceAdaptionUtils.toSingleResource(e.getResource());
        if (experiment == null)
            return;

        if (g.isInstanceOf(experiment, SimulationResource.getInstance(g).Experiment)) {
            final IProject project = SimanticsUI.getProject();
            if (project == null)
                return;

            final IExperimentManager experimentManager = project.getHint(IExperimentManager.KEY_EXPERIMENT_MANAGER);
            if (experimentManager != null) {
                e.add(new PriorityAction(PriorityAction.HIGH+10) {
                    @Override
                    public void run() {
                        ExperimentActivator.scheduleActivation(project.getSession(), project, experimentManager, experiment);
                    }
                });
                e.consume();
                return;
            } /*else {
                ExperimentUtil.activateExperiment(g, experiment);
            }*/

        }
    }

}
