/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.model;

/**
 * Used in
 * {@link IModel#loadExperiment(org.simantics.db.ReadGraph, org.simantics.db.Resource, org.simantics.simulation.project.IExperimentActivationListener)}
 * to indicate that experiment activation has failed due to an error that should
 * be shown to the user and logged.
 * 
 * <p>
 * It is also possible to provide a {@link Runnable} action through
 * {@link #ExperimentLoadingFailed(String, Runnable)} that will be executed
 * after showing the error to the user.
 * 
 * @author Tuukka Lehtonen
 */
public class ExperimentLoadingFailed extends Exception {

    private static final long serialVersionUID = -1465266288034655364L;

    private Runnable helperAction;

    public ExperimentLoadingFailed() {
        super();
    }

    public ExperimentLoadingFailed(String arg0, Throwable arg1) {
        super(arg0, arg1);
    }

    public ExperimentLoadingFailed(String arg0) {
        super(arg0);
    }

    public ExperimentLoadingFailed(String arg0, Runnable helperAction) {
        super(arg0);
        this.helperAction = helperAction;
    }

    public ExperimentLoadingFailed(Throwable arg0) {
        super(arg0);
    }

    public Runnable getHelperAction() {
        return helperAction;
    }

}
