/*******************************************************************************
 * Copyright (c) 2007, 2011 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.experiment;

import java.math.RoundingMode;
import java.text.NumberFormat;
import java.util.Locale;

import org.simantics.utils.format.TimeFormat;

/**
 * @author Tuukka Lehtonen
 */
public class SimulationTimeUtil {

    private static final NumberFormat secondFormatter;
    private static final TimeFormat timeFormat;

    static {
        secondFormatter = NumberFormat.getNumberInstance(Locale.US);
        secondFormatter.setMinimumFractionDigits(2);
        secondFormatter.setMaximumFractionDigits(3);
        secondFormatter.setRoundingMode(RoundingMode.HALF_EVEN);

        timeFormat = new TimeFormat(Double.MAX_VALUE, 3);
    }

    public static String formatSeconds(double time) {
        return secondFormatter.format(time);
    }

    /**
     * Formats a time specified as a double value in seconds in format
     * <code>[Y]y [D]d hh:mm:ss.SSS</code>
     * 
     * @param time
     * @return
     */
    public static String formatHMSS(double time) {
        String result = timeFormat.format(time);
//      System.out.println("formatHMSS(" + time + "): " + result);
        return result;
    }

}
