/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.simulation.experiment;

import org.simantics.simulation.data.Datasource;

/**
 * An experiment that evolves in time.
 */
public interface IDynamicExperiment extends IExperiment {

	/**
	 * Starts or stops simulation depending on the
	 * parameter. 
	 */
	public void simulate(boolean enabled);

	/**
	 * Simulates the experiment at lest the given period of time.
	 * Giving 0 as parameter simulates the experiment one 'step'.
	 * After the duration, the simulation is stopped.
	 */
	public void simulateDuration(double duration);

	/**
	 * Sets the simulation time to some time instance before
	 * the given time. Simulator continues running if it
	 * was already running before rewind. Many simulators don't 
	 * support arbitrary rewinds and therefore reinitialize 
	 * simulation and begin at zero.
	 */
	public void rewindTo(double time);

	/**
	 * Ensure that the current state of the experiment at the time of invocation
	 * is stored so that it can be returned to during a later session.
	 */
	void saveState();

	/**
	 * Get data source for history collection purposes.
	 */
	Datasource getDatasource();

}
