package org.simantics.selectionview;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.adaption.SimpleContextualAdapter;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.variable.ConstantPropertyVariable;
import org.simantics.db.layer0.variable.ModelledVariablePropertyDescriptor;
import org.simantics.db.layer0.variable.StandardGraphChildVariable;
import org.simantics.db.layer0.variable.Variable;

public class PropertyInfoVariableAdapter extends SimpleContextualAdapter<Variable, ModelledVariablePropertyDescriptor> {

	@Override
	public Variable adapt(ReadGraph graph, Resource source, ModelledVariablePropertyDescriptor context) throws DatabaseException {
		return new ConstantPropertyVariable(context.getVariable(), "HasStandardPropertyInfo", new StandardGraphChildVariable(context.getVariable(), null, source), null);
	}

}
