package org.simantics.selectionview;

import java.util.Map;

import org.simantics.browsing.ui.common.ColumnKeys;
import org.simantics.browsing.ui.model.labels.LabelRule;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.utils.datastructures.ArrayMap;

public class CategoryNodeLabelRule implements LabelRule {

	private static final String[] COLS = new String[] { ColumnKeys.DISPLAY_PROPERTY };
	
    @Override
    public boolean isCompatible(Class<?> contentType) {
        return contentType.equals(CategoryNode.class);
    }

    @Override
    public Map<String, String> getLabel(ReadGraph graph, Object content)
            throws DatabaseException {
    	
		String[] result = new String[] { ((CategoryNode)content).getName() };
		return new ArrayMap<String, String>(COLS, result);
		
    }

}
