package org.simantics.selectionview;

import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.ReadGraph;
import org.simantics.db.request.Read;
import org.simantics.db.Session;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.service.QueryControl;

public class SelectionViewResources {
    
    public final Resource AbstractResourceTabContribution;
    public final Resource AbstractResourceTabContribution_HasPriority;
    public final Resource AbstractResourceTabContribution_HasPriority_Inverse;
    public final Resource AbstractResourceTabContribution_HasTest;
    public final Resource AbstractResourceTabContribution_HasTest_Inverse;
    public final Resource AbstractTypedResourceTabContribution;
    public final Resource AbstractTypedResourceTabContribution_HasType;
    public final Resource AbstractTypedResourceTabContribution_HasType_Inverse;
    public final Resource AbstractTypedVariableTabContribution;
    public final Resource AbstractTypedVariableTabContribution_HasType;
    public final Resource AbstractTypedVariableTabContribution_HasType_Inverse;
    public final Resource AbstractVariableTabContribution;
    public final Resource AbstractVariableTabContribution_HasPriority;
    public final Resource AbstractVariableTabContribution_HasPriority_Inverse;
    public final Resource AbstractVariableTabContribution_HasTest;
    public final Resource AbstractVariableTabContribution_HasTest_Inverse;
    public final Resource AbstractVariableTabContribution_testFunction;
    public final Resource AbstractVariableTabContribution_testFunction_Inverse;
    public final Resource CategoryHidden;
    public final Resource ColorParameterType;
    public final Resource DisplayProperty;
    public final Resource DisplayUnit;
    public final Resource DisplayValue;
    public final Resource FontParameterType;
    public final Resource Functions;
    public final Resource Functions_colorModifier;
    public final Resource Functions_displayPropertyValueAccessor;
    public final Resource Functions_displayUnitValueAccessor;
    public final Resource Functions_displayValueValueAccessor;
    public final Resource Functions_fontModifier;
    public final Resource Functions_getEnumerationValues;
    public final Resource Functions_getPropertyChildName;
    public final Resource Functions_inputModifier;
    public final Resource Functions_singleResourceToVariableTransformation;
    public final Resource Functions_singleResourceTransformation;
    public final Resource Functions_singleVariableTransformation;
    public final Resource Functions_standardSelectionInputTransformation;
    public final Resource GenericCategory;
    public final Resource GenericParameterType;
    public final Resource GenericPropertyChild;
    public final Resource HasCustomModifier;
    public final Resource HasCustomModifier_Inverse;
    public final Resource HasDisplayColumn;
    public final Resource HasDisplayColumn_Inverse;
    public final Resource HasDisplayProperty;
    public final Resource HasDisplayProperty_Inverse;
    public final Resource HasDisplayUnit;
    public final Resource HasDisplayUnit_Inverse;
    public final Resource HasDisplayValue;
    public final Resource HasDisplayValue_Inverse;
    public final Resource HasEnumerationValues;
    public final Resource HasEnumerationValues_Inverse;
    public final Resource HasFormatter;
    public final Resource HasFormatter_Inverse;
    public final Resource HasInputModifier;
    public final Resource HasInputModifier_Inverse;
    public final Resource HasStandardPropertyInfo;
    public final Resource HasStandardPropertyInfo_Inverse;
    public final Resource IsShownUnder;
    public final Resource SCLTabContribution;
    public final Resource SCLTabContribution_instantiate;
    public final Resource SCLTabContribution_instantiate_Inverse;
    public final Resource SelectionProcessorContribution;
    public final Resource SelectionTransformation;
    public final Resource SortingName;
    public final Resource SortingName_Inverse;
    public final Resource StandardPropertyInfo;
    public final Resource StandardPropertyInfo_CategoryName;
    public final Resource StandardPropertyInfo_CategoryName_Inverse;
    public final Resource StandardPropertyInfo_CategorySortingName;
    public final Resource StandardPropertyInfo_CategorySortingName_Inverse;
    public final Resource StandardPropertyInfo_IsHidden;
    public final Resource StandardPropertyInfo_IsHidden_Inverse;
    public final Resource TabContribution;
    public final Resource TypedVariableTabContribution;
    public final Resource TypedVariableTabContribution_HasType;
    public final Resource TypedVariableTabContribution_HasType_Inverse;
    public final Resource UnderOf;
    public final Resource VariableTabContribution;
    public final Resource VariableTabContribution_HasPriority;
    public final Resource VariableTabContribution_HasPriority_Inverse;
    public final Resource VariableTabContribution_HasTest;
    public final Resource VariableTabContribution_HasTest_Inverse;
    public final Resource VariableTabContribution_HasView;
    public final Resource VariableTabContribution_HasView_Inverse;
    public final Resource VariableTabContribution_transformation;
    public final Resource VariableTabContribution_transformation_Inverse;
    public final Resource canBeLifted;
    public final Resource canBeLifted_Inverse;
    public final Resource getSpecialCategory;
    public final Resource getSpecialCategory_Inverse;
    public final Resource hidden;
    public final Resource hidden_Inverse;
        
    public static class URIs {
        public static final String AbstractResourceTabContribution = "http://www.simantics.org/SelectionView-1.2/AbstractResourceTabContribution";
        public static final String AbstractResourceTabContribution_HasPriority = "http://www.simantics.org/SelectionView-1.2/AbstractResourceTabContribution/HasPriority";
        public static final String AbstractResourceTabContribution_HasPriority_Inverse = "http://www.simantics.org/SelectionView-1.2/AbstractResourceTabContribution/HasPriority/Inverse";
        public static final String AbstractResourceTabContribution_HasTest = "http://www.simantics.org/SelectionView-1.2/AbstractResourceTabContribution/HasTest";
        public static final String AbstractResourceTabContribution_HasTest_Inverse = "http://www.simantics.org/SelectionView-1.2/AbstractResourceTabContribution/HasTest/Inverse";
        public static final String AbstractTypedResourceTabContribution = "http://www.simantics.org/SelectionView-1.2/AbstractTypedResourceTabContribution";
        public static final String AbstractTypedResourceTabContribution_HasType = "http://www.simantics.org/SelectionView-1.2/AbstractTypedResourceTabContribution/HasType";
        public static final String AbstractTypedResourceTabContribution_HasType_Inverse = "http://www.simantics.org/SelectionView-1.2/AbstractTypedResourceTabContribution/HasType/Inverse";
        public static final String AbstractTypedVariableTabContribution = "http://www.simantics.org/SelectionView-1.2/AbstractTypedVariableTabContribution";
        public static final String AbstractTypedVariableTabContribution_HasType = "http://www.simantics.org/SelectionView-1.2/AbstractTypedVariableTabContribution/HasType";
        public static final String AbstractTypedVariableTabContribution_HasType_Inverse = "http://www.simantics.org/SelectionView-1.2/AbstractTypedVariableTabContribution/HasType/Inverse";
        public static final String AbstractVariableTabContribution = "http://www.simantics.org/SelectionView-1.2/AbstractVariableTabContribution";
        public static final String AbstractVariableTabContribution_HasPriority = "http://www.simantics.org/SelectionView-1.2/AbstractVariableTabContribution/HasPriority";
        public static final String AbstractVariableTabContribution_HasPriority_Inverse = "http://www.simantics.org/SelectionView-1.2/AbstractVariableTabContribution/HasPriority/Inverse";
        public static final String AbstractVariableTabContribution_HasTest = "http://www.simantics.org/SelectionView-1.2/AbstractVariableTabContribution/HasTest";
        public static final String AbstractVariableTabContribution_HasTest_Inverse = "http://www.simantics.org/SelectionView-1.2/AbstractVariableTabContribution/HasTest/Inverse";
        public static final String AbstractVariableTabContribution_testFunction = "http://www.simantics.org/SelectionView-1.2/AbstractVariableTabContribution/testFunction";
        public static final String AbstractVariableTabContribution_testFunction_Inverse = "http://www.simantics.org/SelectionView-1.2/AbstractVariableTabContribution/testFunction/Inverse";
        public static final String CategoryHidden = "http://www.simantics.org/SelectionView-1.2/CategoryHidden";
        public static final String ColorParameterType = "http://www.simantics.org/SelectionView-1.2/ColorParameterType";
        public static final String DisplayProperty = "http://www.simantics.org/SelectionView-1.2/DisplayProperty";
        public static final String DisplayUnit = "http://www.simantics.org/SelectionView-1.2/DisplayUnit";
        public static final String DisplayValue = "http://www.simantics.org/SelectionView-1.2/DisplayValue";
        public static final String FontParameterType = "http://www.simantics.org/SelectionView-1.2/FontParameterType";
        public static final String Functions = "http://www.simantics.org/SelectionView-1.2/Functions";
        public static final String Functions_colorModifier = "http://www.simantics.org/SelectionView-1.2/Functions/colorModifier";
        public static final String Functions_displayPropertyValueAccessor = "http://www.simantics.org/SelectionView-1.2/Functions/displayPropertyValueAccessor";
        public static final String Functions_displayUnitValueAccessor = "http://www.simantics.org/SelectionView-1.2/Functions/displayUnitValueAccessor";
        public static final String Functions_displayValueValueAccessor = "http://www.simantics.org/SelectionView-1.2/Functions/displayValueValueAccessor";
        public static final String Functions_fontModifier = "http://www.simantics.org/SelectionView-1.2/Functions/fontModifier";
        public static final String Functions_getEnumerationValues = "http://www.simantics.org/SelectionView-1.2/Functions/getEnumerationValues";
        public static final String Functions_getPropertyChildName = "http://www.simantics.org/SelectionView-1.2/Functions/getPropertyChildName";
        public static final String Functions_inputModifier = "http://www.simantics.org/SelectionView-1.2/Functions/inputModifier";
        public static final String Functions_singleResourceToVariableTransformation = "http://www.simantics.org/SelectionView-1.2/Functions/singleResourceToVariableTransformation";
        public static final String Functions_singleResourceTransformation = "http://www.simantics.org/SelectionView-1.2/Functions/singleResourceTransformation";
        public static final String Functions_singleVariableTransformation = "http://www.simantics.org/SelectionView-1.2/Functions/singleVariableTransformation";
        public static final String Functions_standardSelectionInputTransformation = "http://www.simantics.org/SelectionView-1.2/Functions/standardSelectionInputTransformation";
        public static final String GenericCategory = "http://www.simantics.org/SelectionView-1.2/GenericCategory";
        public static final String GenericParameterType = "http://www.simantics.org/SelectionView-1.2/GenericParameterType";
        public static final String GenericPropertyChild = "http://www.simantics.org/SelectionView-1.2/GenericPropertyChild";
        public static final String HasCustomModifier = "http://www.simantics.org/SelectionView-1.2/HasCustomModifier";
        public static final String HasCustomModifier_Inverse = "http://www.simantics.org/SelectionView-1.2/HasCustomModifier/Inverse";
        public static final String HasDisplayColumn = "http://www.simantics.org/SelectionView-1.2/HasDisplayColumn";
        public static final String HasDisplayColumn_Inverse = "http://www.simantics.org/SelectionView-1.2/HasDisplayColumn/Inverse";
        public static final String HasDisplayProperty = "http://www.simantics.org/SelectionView-1.2/HasDisplayProperty";
        public static final String HasDisplayProperty_Inverse = "http://www.simantics.org/SelectionView-1.2/HasDisplayProperty/Inverse";
        public static final String HasDisplayUnit = "http://www.simantics.org/SelectionView-1.2/HasDisplayUnit";
        public static final String HasDisplayUnit_Inverse = "http://www.simantics.org/SelectionView-1.2/HasDisplayUnit/Inverse";
        public static final String HasDisplayValue = "http://www.simantics.org/SelectionView-1.2/HasDisplayValue";
        public static final String HasDisplayValue_Inverse = "http://www.simantics.org/SelectionView-1.2/HasDisplayValue/Inverse";
        public static final String HasEnumerationValues = "http://www.simantics.org/SelectionView-1.2/HasEnumerationValues";
        public static final String HasEnumerationValues_Inverse = "http://www.simantics.org/SelectionView-1.2/HasEnumerationValues/Inverse";
        public static final String HasFormatter = "http://www.simantics.org/SelectionView-1.2/HasFormatter";
        public static final String HasFormatter_Inverse = "http://www.simantics.org/SelectionView-1.2/HasFormatter/Inverse";
        public static final String HasInputModifier = "http://www.simantics.org/SelectionView-1.2/HasInputModifier";
        public static final String HasInputModifier_Inverse = "http://www.simantics.org/SelectionView-1.2/HasInputModifier/Inverse";
        public static final String HasStandardPropertyInfo = "http://www.simantics.org/SelectionView-1.2/HasStandardPropertyInfo";
        public static final String HasStandardPropertyInfo_Inverse = "http://www.simantics.org/SelectionView-1.2/HasStandardPropertyInfo/Inverse";
        public static final String IsShownUnder = "http://www.simantics.org/SelectionView-1.2/IsShownUnder";
        public static final String SCLTabContribution = "http://www.simantics.org/SelectionView-1.2/SCLTabContribution";
        public static final String SCLTabContribution_instantiate = "http://www.simantics.org/SelectionView-1.2/SCLTabContribution/instantiate";
        public static final String SCLTabContribution_instantiate_Inverse = "http://www.simantics.org/SelectionView-1.2/SCLTabContribution/instantiate/Inverse";
        public static final String SelectionProcessorContribution = "http://www.simantics.org/SelectionView-1.2/SelectionProcessorContribution";
        public static final String SelectionTransformation = "http://www.simantics.org/SelectionView-1.2/SelectionTransformation";
        public static final String SortingName = "http://www.simantics.org/SelectionView-1.2/SortingName";
        public static final String SortingName_Inverse = "http://www.simantics.org/SelectionView-1.2/SortingName/Inverse";
        public static final String StandardPropertyInfo = "http://www.simantics.org/SelectionView-1.2/StandardPropertyInfo";
        public static final String StandardPropertyInfo_CategoryName = "http://www.simantics.org/SelectionView-1.2/StandardPropertyInfo/CategoryName";
        public static final String StandardPropertyInfo_CategoryName_Inverse = "http://www.simantics.org/SelectionView-1.2/StandardPropertyInfo/CategoryName/Inverse";
        public static final String StandardPropertyInfo_CategorySortingName = "http://www.simantics.org/SelectionView-1.2/StandardPropertyInfo/CategorySortingName";
        public static final String StandardPropertyInfo_CategorySortingName_Inverse = "http://www.simantics.org/SelectionView-1.2/StandardPropertyInfo/CategorySortingName/Inverse";
        public static final String StandardPropertyInfo_IsHidden = "http://www.simantics.org/SelectionView-1.2/StandardPropertyInfo/IsHidden";
        public static final String StandardPropertyInfo_IsHidden_Inverse = "http://www.simantics.org/SelectionView-1.2/StandardPropertyInfo/IsHidden/Inverse";
        public static final String TabContribution = "http://www.simantics.org/SelectionView-1.2/TabContribution";
        public static final String TypedVariableTabContribution = "http://www.simantics.org/SelectionView-1.2/TypedVariableTabContribution";
        public static final String TypedVariableTabContribution_HasType = "http://www.simantics.org/SelectionView-1.2/TypedVariableTabContribution/HasType";
        public static final String TypedVariableTabContribution_HasType_Inverse = "http://www.simantics.org/SelectionView-1.2/TypedVariableTabContribution/HasType/Inverse";
        public static final String UnderOf = "http://www.simantics.org/SelectionView-1.2/UnderOf";
        public static final String VariableTabContribution = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution";
        public static final String VariableTabContribution_HasPriority = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/HasPriority";
        public static final String VariableTabContribution_HasPriority_Inverse = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/HasPriority/Inverse";
        public static final String VariableTabContribution_HasTest = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/HasTest";
        public static final String VariableTabContribution_HasTest_Inverse = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/HasTest/Inverse";
        public static final String VariableTabContribution_HasView = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/HasView";
        public static final String VariableTabContribution_HasView_Inverse = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/HasView/Inverse";
        public static final String VariableTabContribution_transformation = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/transformation";
        public static final String VariableTabContribution_transformation_Inverse = "http://www.simantics.org/SelectionView-1.2/VariableTabContribution/transformation/Inverse";
        public static final String canBeLifted = "http://www.simantics.org/SelectionView-1.2/canBeLifted";
        public static final String canBeLifted_Inverse = "http://www.simantics.org/SelectionView-1.2/canBeLifted/Inverse";
        public static final String getSpecialCategory = "http://www.simantics.org/SelectionView-1.2/getSpecialCategory";
        public static final String getSpecialCategory_Inverse = "http://www.simantics.org/SelectionView-1.2/getSpecialCategory/Inverse";
        public static final String hidden = "http://www.simantics.org/SelectionView-1.2/hidden";
        public static final String hidden_Inverse = "http://www.simantics.org/SelectionView-1.2/hidden/Inverse";
    }
    
    public static Resource getResourceOrNull(ReadGraph graph, String uri) {
        try {
            return graph.getResource(uri);
        } catch(DatabaseException e) {
            System.err.println(e.getMessage());
            return null;
        }
    }
    
    public SelectionViewResources(ReadGraph graph) {
        AbstractResourceTabContribution = getResourceOrNull(graph, URIs.AbstractResourceTabContribution);
        AbstractResourceTabContribution_HasPriority = getResourceOrNull(graph, URIs.AbstractResourceTabContribution_HasPriority);
        AbstractResourceTabContribution_HasPriority_Inverse = getResourceOrNull(graph, URIs.AbstractResourceTabContribution_HasPriority_Inverse);
        AbstractResourceTabContribution_HasTest = getResourceOrNull(graph, URIs.AbstractResourceTabContribution_HasTest);
        AbstractResourceTabContribution_HasTest_Inverse = getResourceOrNull(graph, URIs.AbstractResourceTabContribution_HasTest_Inverse);
        AbstractTypedResourceTabContribution = getResourceOrNull(graph, URIs.AbstractTypedResourceTabContribution);
        AbstractTypedResourceTabContribution_HasType = getResourceOrNull(graph, URIs.AbstractTypedResourceTabContribution_HasType);
        AbstractTypedResourceTabContribution_HasType_Inverse = getResourceOrNull(graph, URIs.AbstractTypedResourceTabContribution_HasType_Inverse);
        AbstractTypedVariableTabContribution = getResourceOrNull(graph, URIs.AbstractTypedVariableTabContribution);
        AbstractTypedVariableTabContribution_HasType = getResourceOrNull(graph, URIs.AbstractTypedVariableTabContribution_HasType);
        AbstractTypedVariableTabContribution_HasType_Inverse = getResourceOrNull(graph, URIs.AbstractTypedVariableTabContribution_HasType_Inverse);
        AbstractVariableTabContribution = getResourceOrNull(graph, URIs.AbstractVariableTabContribution);
        AbstractVariableTabContribution_HasPriority = getResourceOrNull(graph, URIs.AbstractVariableTabContribution_HasPriority);
        AbstractVariableTabContribution_HasPriority_Inverse = getResourceOrNull(graph, URIs.AbstractVariableTabContribution_HasPriority_Inverse);
        AbstractVariableTabContribution_HasTest = getResourceOrNull(graph, URIs.AbstractVariableTabContribution_HasTest);
        AbstractVariableTabContribution_HasTest_Inverse = getResourceOrNull(graph, URIs.AbstractVariableTabContribution_HasTest_Inverse);
        AbstractVariableTabContribution_testFunction = getResourceOrNull(graph, URIs.AbstractVariableTabContribution_testFunction);
        AbstractVariableTabContribution_testFunction_Inverse = getResourceOrNull(graph, URIs.AbstractVariableTabContribution_testFunction_Inverse);
        CategoryHidden = getResourceOrNull(graph, URIs.CategoryHidden);
        ColorParameterType = getResourceOrNull(graph, URIs.ColorParameterType);
        DisplayProperty = getResourceOrNull(graph, URIs.DisplayProperty);
        DisplayUnit = getResourceOrNull(graph, URIs.DisplayUnit);
        DisplayValue = getResourceOrNull(graph, URIs.DisplayValue);
        FontParameterType = getResourceOrNull(graph, URIs.FontParameterType);
        Functions = getResourceOrNull(graph, URIs.Functions);
        Functions_colorModifier = getResourceOrNull(graph, URIs.Functions_colorModifier);
        Functions_displayPropertyValueAccessor = getResourceOrNull(graph, URIs.Functions_displayPropertyValueAccessor);
        Functions_displayUnitValueAccessor = getResourceOrNull(graph, URIs.Functions_displayUnitValueAccessor);
        Functions_displayValueValueAccessor = getResourceOrNull(graph, URIs.Functions_displayValueValueAccessor);
        Functions_fontModifier = getResourceOrNull(graph, URIs.Functions_fontModifier);
        Functions_getEnumerationValues = getResourceOrNull(graph, URIs.Functions_getEnumerationValues);
        Functions_getPropertyChildName = getResourceOrNull(graph, URIs.Functions_getPropertyChildName);
        Functions_inputModifier = getResourceOrNull(graph, URIs.Functions_inputModifier);
        Functions_singleResourceToVariableTransformation = getResourceOrNull(graph, URIs.Functions_singleResourceToVariableTransformation);
        Functions_singleResourceTransformation = getResourceOrNull(graph, URIs.Functions_singleResourceTransformation);
        Functions_singleVariableTransformation = getResourceOrNull(graph, URIs.Functions_singleVariableTransformation);
        Functions_standardSelectionInputTransformation = getResourceOrNull(graph, URIs.Functions_standardSelectionInputTransformation);
        GenericCategory = getResourceOrNull(graph, URIs.GenericCategory);
        GenericParameterType = getResourceOrNull(graph, URIs.GenericParameterType);
        GenericPropertyChild = getResourceOrNull(graph, URIs.GenericPropertyChild);
        HasCustomModifier = getResourceOrNull(graph, URIs.HasCustomModifier);
        HasCustomModifier_Inverse = getResourceOrNull(graph, URIs.HasCustomModifier_Inverse);
        HasDisplayColumn = getResourceOrNull(graph, URIs.HasDisplayColumn);
        HasDisplayColumn_Inverse = getResourceOrNull(graph, URIs.HasDisplayColumn_Inverse);
        HasDisplayProperty = getResourceOrNull(graph, URIs.HasDisplayProperty);
        HasDisplayProperty_Inverse = getResourceOrNull(graph, URIs.HasDisplayProperty_Inverse);
        HasDisplayUnit = getResourceOrNull(graph, URIs.HasDisplayUnit);
        HasDisplayUnit_Inverse = getResourceOrNull(graph, URIs.HasDisplayUnit_Inverse);
        HasDisplayValue = getResourceOrNull(graph, URIs.HasDisplayValue);
        HasDisplayValue_Inverse = getResourceOrNull(graph, URIs.HasDisplayValue_Inverse);
        HasEnumerationValues = getResourceOrNull(graph, URIs.HasEnumerationValues);
        HasEnumerationValues_Inverse = getResourceOrNull(graph, URIs.HasEnumerationValues_Inverse);
        HasFormatter = getResourceOrNull(graph, URIs.HasFormatter);
        HasFormatter_Inverse = getResourceOrNull(graph, URIs.HasFormatter_Inverse);
        HasInputModifier = getResourceOrNull(graph, URIs.HasInputModifier);
        HasInputModifier_Inverse = getResourceOrNull(graph, URIs.HasInputModifier_Inverse);
        HasStandardPropertyInfo = getResourceOrNull(graph, URIs.HasStandardPropertyInfo);
        HasStandardPropertyInfo_Inverse = getResourceOrNull(graph, URIs.HasStandardPropertyInfo_Inverse);
        IsShownUnder = getResourceOrNull(graph, URIs.IsShownUnder);
        SCLTabContribution = getResourceOrNull(graph, URIs.SCLTabContribution);
        SCLTabContribution_instantiate = getResourceOrNull(graph, URIs.SCLTabContribution_instantiate);
        SCLTabContribution_instantiate_Inverse = getResourceOrNull(graph, URIs.SCLTabContribution_instantiate_Inverse);
        SelectionProcessorContribution = getResourceOrNull(graph, URIs.SelectionProcessorContribution);
        SelectionTransformation = getResourceOrNull(graph, URIs.SelectionTransformation);
        SortingName = getResourceOrNull(graph, URIs.SortingName);
        SortingName_Inverse = getResourceOrNull(graph, URIs.SortingName_Inverse);
        StandardPropertyInfo = getResourceOrNull(graph, URIs.StandardPropertyInfo);
        StandardPropertyInfo_CategoryName = getResourceOrNull(graph, URIs.StandardPropertyInfo_CategoryName);
        StandardPropertyInfo_CategoryName_Inverse = getResourceOrNull(graph, URIs.StandardPropertyInfo_CategoryName_Inverse);
        StandardPropertyInfo_CategorySortingName = getResourceOrNull(graph, URIs.StandardPropertyInfo_CategorySortingName);
        StandardPropertyInfo_CategorySortingName_Inverse = getResourceOrNull(graph, URIs.StandardPropertyInfo_CategorySortingName_Inverse);
        StandardPropertyInfo_IsHidden = getResourceOrNull(graph, URIs.StandardPropertyInfo_IsHidden);
        StandardPropertyInfo_IsHidden_Inverse = getResourceOrNull(graph, URIs.StandardPropertyInfo_IsHidden_Inverse);
        TabContribution = getResourceOrNull(graph, URIs.TabContribution);
        TypedVariableTabContribution = getResourceOrNull(graph, URIs.TypedVariableTabContribution);
        TypedVariableTabContribution_HasType = getResourceOrNull(graph, URIs.TypedVariableTabContribution_HasType);
        TypedVariableTabContribution_HasType_Inverse = getResourceOrNull(graph, URIs.TypedVariableTabContribution_HasType_Inverse);
        UnderOf = getResourceOrNull(graph, URIs.UnderOf);
        VariableTabContribution = getResourceOrNull(graph, URIs.VariableTabContribution);
        VariableTabContribution_HasPriority = getResourceOrNull(graph, URIs.VariableTabContribution_HasPriority);
        VariableTabContribution_HasPriority_Inverse = getResourceOrNull(graph, URIs.VariableTabContribution_HasPriority_Inverse);
        VariableTabContribution_HasTest = getResourceOrNull(graph, URIs.VariableTabContribution_HasTest);
        VariableTabContribution_HasTest_Inverse = getResourceOrNull(graph, URIs.VariableTabContribution_HasTest_Inverse);
        VariableTabContribution_HasView = getResourceOrNull(graph, URIs.VariableTabContribution_HasView);
        VariableTabContribution_HasView_Inverse = getResourceOrNull(graph, URIs.VariableTabContribution_HasView_Inverse);
        VariableTabContribution_transformation = getResourceOrNull(graph, URIs.VariableTabContribution_transformation);
        VariableTabContribution_transformation_Inverse = getResourceOrNull(graph, URIs.VariableTabContribution_transformation_Inverse);
        canBeLifted = getResourceOrNull(graph, URIs.canBeLifted);
        canBeLifted_Inverse = getResourceOrNull(graph, URIs.canBeLifted_Inverse);
        getSpecialCategory = getResourceOrNull(graph, URIs.getSpecialCategory);
        getSpecialCategory_Inverse = getResourceOrNull(graph, URIs.getSpecialCategory_Inverse);
        hidden = getResourceOrNull(graph, URIs.hidden);
        hidden_Inverse = getResourceOrNull(graph, URIs.hidden_Inverse);
    }
    
    public static SelectionViewResources getInstance(ReadGraph graph) {
        Session session = graph.getSession();
        SelectionViewResources ret = session.peekService(SelectionViewResources.class);
        if(ret == null) {
            QueryControl qc = graph.getService(QueryControl.class);
            ret = new SelectionViewResources(qc.getIndependentGraph(graph));
            session.registerService(SelectionViewResources.class, ret);
        }
        return ret;
    }
    
    public static SelectionViewResources getInstance(RequestProcessor session) throws DatabaseException {
        SelectionViewResources ret = session.peekService(SelectionViewResources.class);
        if(ret == null) {
            ret = session.syncRequest(new Read<SelectionViewResources>() {
                public SelectionViewResources perform(ReadGraph graph) throws DatabaseException {
                    QueryControl qc = graph.getService(QueryControl.class);
                    return new SelectionViewResources(qc.getIndependentGraph(graph));
                }
            });
            session.registerService(SelectionViewResources.class, ret);
        }
        return ret;
    }
    
}

