package org.simantics.scl.ui.tests;

import java.util.Comparator;
import java.util.List;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.dialogs.FilteredItemsSelectionDialog;
import org.eclipse.ui.dialogs.SearchPattern;
import org.simantics.scl.compiler.testing.TestRunnable;
import org.simantics.scl.ui.Activator;

public class SCLTestsDialog extends FilteredItemsSelectionDialog {

    private static final String SCL_TEST_DIALOG_SETTINGS = "SCLTestDialogSettings";
    
    private List<TestRunnable> tests;

    public SCLTestsDialog(Shell shell, List<TestRunnable> tests, boolean multi) {
        super(shell, multi);
        this.tests = tests;
        setTitle("Run SCL Tests");
        setListLabelProvider(new LabelProvider() {
            
            @Override
            public String getText(Object element) {
                if (element != null)
                    return ((TestRunnable) element).getName();
                return "No name!";
            }
        });
        setSelectionHistory(new ResourceSelectionHistory());
    }
    
    private class ResourceSelectionHistory extends SelectionHistory {
        /*
         * @see org.eclipse.ui.dialogs.FilteredItemsSelectionDialog.SelectionHistory#restoreItemFromMemento(org.eclipse.ui.IMemento)
         */
        protected Object restoreItemFromMemento(IMemento element) {
           String testName = element.getString("test"); //$NON-NLS-1$
           return findTestByName(testName);
        }
        /*
         * @see org.eclipse.ui.dialogs.FilteredItemsSelectionDialog.SelectionHistory#storeItemToMemento(java.lang.Object,
         *      org.eclipse.ui.IMemento)
         */
        protected void storeItemToMemento(Object item, IMemento element) {
            TestRunnable runnable = (TestRunnable) item;
            element.putString("test", runnable.getName()); //$NON-NLS-1$
        }
     }
    
    private TestRunnable findTestByName(String name) {
        for (TestRunnable runnable : tests) {
            if (runnable.getName().equals(name))
                return runnable;
        }
        return null;
    }
    
    @Override
    protected Control createExtendedContentArea(Composite parent) {
        // TODO Auto-generated method stub
        return null;
    }
    
    @Override
    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
        Button okButton = getButton(IDialogConstants.OK_ID);
        okButton.setText("Run test");
        setButtonLayoutData(okButton);
    }

    @Override
    protected IDialogSettings getDialogSettings() {
        IDialogSettings settings = Activator.getInstance().getDialogSettings()
                .getSection(SCL_TEST_DIALOG_SETTINGS);
        if (settings == null) {
            settings = Activator.getInstance().getDialogSettings()
                    .addNewSection(SCL_TEST_DIALOG_SETTINGS);
        }
        return settings;
    }

    @Override
    protected IStatus validateItem(Object item) {
        return Status.OK_STATUS;
    }

    @Override
    protected ItemsFilter createFilter() {
        return new ItemsFilter() {
            {
                String patternText = getPattern();
                patternMatcher = new SearchPattern();
                if(patternText != null && patternText.length() > 0)
                    patternMatcher.setPattern(patternText);
                else 
                    patternMatcher.setPattern("**");
            }
            @Override
            public boolean matchItem(Object item) {
                String testName = ((TestRunnable) item).getName();
                if(getPattern().indexOf('/') > 0)
                    return matches(testName);
                else {
                    for(String part : (testName.split("/")))
                        if(matches(part))
                            return true;
                    return false;
                }
            }
            
            @Override
            public boolean isConsistentItem(Object item) {
                return true;
            }
        };
    }

    Comparator<TestRunnable> comparator = new Comparator<TestRunnable>() {
        @Override
        public int compare(TestRunnable o1, TestRunnable o2) {
            return o1.getName().compareTo(o2.getName());
        }
    };
    
    @Override
    protected Comparator<TestRunnable> getItemsComparator() {
        return comparator;
    }

    @Override
    protected void fillContentProvider(AbstractContentProvider contentProvider,
            ItemsFilter itemsFilter, IProgressMonitor progressMonitor)
            throws CoreException {
        progressMonitor.beginTask("Searching tests..", tests.size());
        for (TestRunnable test : tests) {
            contentProvider.add(test, itemsFilter);
            progressMonitor.worked(1);
        }
        progressMonitor.done();
    }

    @Override
    public String getElementName(Object item) {
        return ((TestRunnable) item).getName();
    }
}
