package org.simantics.scl.ui.modulebrowser;

import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.SWT;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.part.ViewPart;
import org.simantics.scl.osgi.SCLOsgi;
import org.simantics.scl.ui.Activator;
import org.simantics.scl.ui.editor2.OpenSCLModule;

public class SCLModuleBrowser extends ViewPart {

    SCLModuleTree content;
    
    @Override
    public void createPartControl(Composite parent) {
        this.content = new SCLModuleTree(parent, SWT.NONE, SCLOsgi.MODULE_REPOSITORY);
        setPartName("SCL Modules");
        
        // Opening modules
        content.addDoubleClickListener(new IDoubleClickListener() {
            @Override
            public void doubleClick(DoubleClickEvent event) {
                ISelection selection = event.getSelection();
                if(!(selection instanceof IStructuredSelection))
                    return;
                ModuleNameTreeEntry entry = (ModuleNameTreeEntry)((IStructuredSelection)selection).getFirstElement();
                if(entry.isModule)
                    OpenSCLModule.scheduleOpenModule(entry.fullName);
            }
        });
        
        // Toolbar
        IToolBarManager toolBarManager = getViewSite().getActionBars().getToolBarManager();
        toolBarManager.add(new Action("Refresh modules",
                Activator.imageDescriptorFromPlugin("org.simantics.scl.ui", "icons/arrow_refresh.png")) {
            @Override
            public void run() {
                refresh();
            }
        });
        
        // Context menu
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener() {
            public void menuAboutToShow(IMenuManager manager) {
                ModuleNameTreeEntry entry = (ModuleNameTreeEntry)content.getStructuredSelection().getFirstElement();
                manager.add(new Action("New Module...") {
                    @Override
                    public void run() {
                        CreateModuleDialog dialog = new CreateModuleDialog(content.getControl().getShell(), SCLModuleBrowser.this);
                        dialog.setPackage(entry.fullName);
                        dialog.open();
                    }
                });
            }
        });
        Menu menu = menuMgr.createContextMenu(content.getControl());
        content.getControl().setMenu(menu);
        getSite().registerContextMenu(menuMgr, content);
    }
    
    public void refresh() {
        SCLOsgi.MODULE_REPOSITORY.getSourceRepository().checkUpdates();
        content.recalculateInput();
    }

    @Override
    public void setFocus() {
        content.getControl().setFocus();
    }

}
