package org.simantics.scl.ui.imports.internal;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.ui.imports.ImportModulesAction;

public class ManualImportModulesAction extends ImportModulesAction {
    
    public static final ManualImportModulesAction INSTANCE = new ManualImportModulesAction();
            
    public ManualImportModulesAction() {
        super("Add freeform module", 100.0);
    }

    @Override
    public boolean editImports(Shell shell, ArrayList<CommandSessionImportEntry> imports) {
        InputDialog dialog = new InputDialog(shell, "Select module", "Write the full name of the module",
                "", null);
        if(dialog.open() == Dialog.OK) {
            new CommandSessionImportEntry(dialog.getValue(), "", true).addTo(imports);
            return true;
        }
        else
            return false;
    }

}
