package org.simantics.scl.ui.editor2;

import org.eclipse.jface.resource.FontDescriptor;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.TextAttribute;
import org.eclipse.jface.text.presentation.PresentationReconciler;
import org.eclipse.jface.text.rules.DefaultDamagerRepairer;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.ITokenScanner;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.IWordDetector;
import org.eclipse.jface.text.rules.RuleBasedScanner;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;
import org.eclipse.jface.text.rules.WordRule;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.RGB;
import org.simantics.scl.ui.info.SCLInfo;

public class SCLPresentationReconciler extends PresentationReconciler {
    private static final FontDescriptor FONT_NORMAL = FontDescriptor.createFrom("Consolas", 10, SWT.NORMAL);
    private static final FontDescriptor FONT_BOLD = FontDescriptor.createFrom("Consolas", 10, SWT.BOLD);
    
    public SCLPresentationReconciler(ResourceManager resourceManager) {
        Font font = resourceManager.createFont(FONT_NORMAL);
        {
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(new SingleTokenScanner(new TextAttribute(
                    resourceManager.createColor(new RGB(63, 127, 95)),
                    null,
                    0,
                    font
                    )));
            setDamager(dr, SCLPartitionScanner.SCL_COMMENT);
            setRepairer(dr, SCLPartitionScanner.SCL_COMMENT);
        }
        {
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(new StringTokenScanner(new TextAttribute(
                    resourceManager.createColor(new RGB(42, 0, 255)),
                    null,
                    0,
                    font
                    )));
            setDamager(dr, SCLPartitionScanner.SCL_STRING);
            setRepairer(dr, SCLPartitionScanner.SCL_STRING);
        }
        {
            DefaultDamagerRepairer dr = new DefaultDamagerRepairer(getSclTokenScanner(resourceManager));

            setRepairer(dr, IDocument.DEFAULT_CONTENT_TYPE);
            setDamager(dr, IDocument.DEFAULT_CONTENT_TYPE);
        }
    }
    
    private static ITokenScanner getSclTokenScanner(ResourceManager resourceManager) {
        RuleBasedScanner scanner = new RuleBasedScanner();
        
        Token defaultToken = new Token(
                new TextAttribute(
                        resourceManager.createColor(new RGB(0, 0, 0)),
                        null,
                        0,
                        resourceManager.createFont(FONT_NORMAL)
                ));
        Token reserved = new Token(
                new TextAttribute(
                        resourceManager.createColor(new RGB(127, 0, 85)),
                        null,
                        SWT.BOLD,
                        resourceManager.createFont(FONT_BOLD)
                ));

        WordRule reservedWord = new WordRule(new IWordDetector() {
            @Override
            public boolean isWordStart(char c) {
                return ('a' <= c && c <= 'z')
                     || ('A' <= c && c <= 'Z')
                     || c == '_' || c == '?';
            }
            @Override
            public boolean isWordPart(char c) {
                return ('a' <= c && c <= 'z')
                        || ('A' <= c && c <= 'Z')
                        || ('0' <= c && c <= '9')
                        || c == '_' || c == '.' || c == '\'';
            }
        }, defaultToken);

        for(String word : SCLInfo.RESERVED_WORDS)
            reservedWord.addWord(word, reserved);
        
        scanner.setRules(new IRule[] {
                new WhitespaceRule(new IWhitespaceDetector() {
                    @Override
                    public boolean isWhitespace(char c) {
                        return c==' ' || c=='\t' || c=='\n' || c=='\r';
                    }
                }, defaultToken),
                reservedWord
        });
        scanner.setDefaultReturnToken(defaultToken);
        
        return scanner;
    }
}
