package org.simantics.scl.ui.browser;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.swt.SWTError;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class LaunchSCLDocumentationBrowser extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell shell = new Shell(display);
        shell.setText("SCL Documentation browser");
        shell.setLayout(new FillLayout());
        SCLDocumentationBrowser browser;
        try {
            browser = new SCLDocumentationBrowser(shell);
        } catch (SWTError e) {
            System.out.println("Could not instantiate the browser: " + e.getMessage());
            display.dispose();
            return null;
        }
        browser.setLocation("Prelude");
        shell.open();
        
        return null;
    }

}
