package org.simantics.scl.osgi;

import java.util.ArrayList;

import org.simantics.scl.compiler.errors.DoesNotExist;
import org.simantics.scl.compiler.errors.Failable;
import org.simantics.scl.compiler.module.Module;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptions;
import org.simantics.scl.compiler.module.options.ModuleCompilationOptionsAdvisor;
import org.simantics.scl.compiler.module.repository.ModuleRepository;
import org.simantics.scl.compiler.source.repository.ModuleSourceRepository;
import org.simantics.scl.compiler.testing.repository.TestRepository;
import org.simantics.scl.osgi.internal.Activator;
import org.simantics.scl.osgi.internal.ServiceBasedModuleSourceRepository;
import org.simantics.scl.osgi.internal.ServiceBasedTestRepository;

import gnu.trove.procedure.TObjectProcedure;


public class SCLOsgi {

    private SCLOsgi() {}
    
    public static ModuleSourceRepository SOURCE_REPOSITORY = new ServiceBasedModuleSourceRepository(Activator.getContext());
    public static ModuleRepository MODULE_REPOSITORY = new ModuleRepository(SOURCE_REPOSITORY);
    public static TestRepository TEST_REPOSITORY = new ServiceBasedTestRepository(Activator.getContext());

    static {
        MODULE_REPOSITORY.setAdvisor(new ModuleCompilationOptionsAdvisor() {
            ModuleCompilationOptions options = null;
            @Override
            public ModuleCompilationOptions getOptions(String moduleName) {
                if(options == null) {
                    options = new ModuleCompilationOptions(false);
                    options.collectDebugInfo = Activator.getContext().getProperty("osgi.dev") != null; //$NON-NLS-1$
                }
                return options; 
            }
        });
    }
    
    public static String compileAllModules() {
        ArrayList<String> modulesWithErrors = new ArrayList<String>(); 
        SCLOsgi.SOURCE_REPOSITORY.forAllModules(new TObjectProcedure<String>() {
            @Override
            public boolean execute(String moduleName) {
                System.out.print(moduleName);
                System.out.print(" - ");
                Failable<Module> module = SCLOsgi.MODULE_REPOSITORY.getModule(moduleName);
                if(module.didSucceed())
                    System.out.println("succeeded");
                else if(module == DoesNotExist.INSTANCE)
                    System.out.println("does not exist"); // should not happen
                else {
                    System.out.println("error");
                    modulesWithErrors.add(moduleName);
                }
                return true;
            }
        });
        if(!modulesWithErrors.isEmpty()) {
            StringBuilder b = new StringBuilder();
            b.append("Some SCL modules failed to compile:");
            for(String module : modulesWithErrors)
                b.append(' ').append(module);
            return b.toString();
        }
        return null;
    }
}
