package org.simantics.scl.compiler.types.util;


public enum Polarity {
    NO_POLARITY("?"),
    POSITIVE("+"),
    NEGATIVE("-"),
    BIPOLAR("=");
    
    private Polarity(String symbol) {
        this.symbol = symbol;
    }

    private final String symbol;
    private Polarity flipped;
    private Polarity[] combi = new Polarity[4];
    
    static {
        for(int ia=0;ia<4;++ia) {
            Polarity a = values()[ia];
            a.flipped = values()[ ((ia&1)<<1) | ((ia&2)>>1) ];
            for(int ib=0;ib<4;++ib) {
                a.combi[ib] = values()[ia | ib];
            }
        }
    }
    
    public Polarity flip() {
        return flipped;
    }
    
    public Polarity add(Polarity other) {
        return combi[other.ordinal()];
    }

    public String getSymbol() {
        return symbol;
    }
    
    public boolean isPositive() {
        return (ordinal()&1) != 0;                
    }
    
    public boolean isNegative() {
        return (ordinal()&2) != 0;
    }
}
