package org.simantics.scl.compiler.module.repository;

public class ImportFailure {
    public final static Object MODULE_DOES_NOT_EXIST_REASON = new Object();
    
    public final long location;
    public final String moduleName;
    public final Object reason;
    
    public ImportFailure(long location, String moduleName, Object reason) {
        this.location = location;
        this.moduleName = moduleName;
        this.reason = reason;
    }
    
    @Override
    public String toString() {
        return "Failed to import " + moduleName + ", because it " + 
                (reason == ImportFailure.MODULE_DOES_NOT_EXIST_REASON 
                        ? "does not exist."
                        : "contains compilation errors.");
    }
}
