package org.simantics.scl.compiler.internal.parsing.declarations;

import java.util.ArrayList;

import org.simantics.scl.compiler.elaboration.expressions.EVar;
import org.simantics.scl.compiler.internal.parsing.types.TypeAst;

public class DDerivingInstanceAst extends DeclarationAst {
    public final TypeAst[] context;
    public final EVar name;
    public final TypeAst[] types;
    
    public DDerivingInstanceAst(ArrayList<TypeAst> context, EVar name, 
            TypeAst[] types) {
        this.context = context.toArray(new TypeAst[context.size()]);
        this.name = name;
        this.types = types;
    }
    
    @Override
    public void toString(int indentation, StringBuilder b) {
        for(int i=0;i<indentation;++i) b.append("    ");
        b.append("deriving instance ");
        if(context.length > 0) {
            b.append("(");
            for(int i=0;i<context.length;++i) {
                if(i>0)
                    b.append(", ");
                context[i].toString(b);
            }
            b.append(") => ");
            
        }
        b.append(name);
        for(TypeAst type : types) {
            b.append(' ');
            type.toString(b, 1);
        }
    }
}
