package org.simantics.scl.compiler.internal.elaboration.constraints;

import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.top.SCLCompilerConfiguration;
import org.simantics.scl.compiler.types.TPred;
import org.simantics.scl.compiler.types.Type;

class Reduction {
    Expression generator;
    Type[] parameters;
    TPred[] demands;
    
    public Reduction(Expression generator, Type[] parameters, TPred[] demands) {
        if(SCLCompilerConfiguration.DEBUG) {
            if(generator == null)
                throw new NullPointerException();
            for(Type parameter : parameters)
                if(parameter == null)
                    throw new NullPointerException();
            for(Type demand : demands)
                if(demand == null)
                    throw new NullPointerException();
        }
        this.generator = generator;
        this.parameters = parameters;
        this.demands = demands;
    }
}
