package org.simantics.scl.compiler.internal.codegen.continuations;

import org.simantics.scl.compiler.internal.codegen.references.BoundVar;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.references.ValRef;
import org.simantics.scl.compiler.internal.codegen.ssa.SSABlock;
import org.simantics.scl.compiler.internal.codegen.ssa.SSAFunction;
import org.simantics.scl.compiler.internal.codegen.ssa.exits.Jump;
import org.simantics.scl.compiler.internal.codegen.utils.CopyContext;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;

public abstract class Cont implements ICont {
    
    transient ContRef occurrence;

    @Override
    public ContRef createOccurrence() {
        return new ContRef(this);
    }
    
    public void replaceWith(Cont other) {
        ContRef cur = occurrence;
        if(cur != null) {
            while(true) {
                cur.binding = other;
                if(cur.next == null)
                    break;
                else
                    cur = cur.next;
            }
            cur.next = other.occurrence;
            if(other.occurrence != null)
                other.occurrence.prev = cur;
            other.occurrence = occurrence;
            occurrence = null;
        }        
    }
    
    public abstract int getArity();    
    public abstract Type getParameterType(int parameterId);
    
    public int occurrenceCount() {
        int count = 0;
        for(ContRef ref = occurrence;ref != null;ref=ref.next)
            ++count;
        return count;
    }

    public boolean hasMoreThanOneOccurences() {
        return occurrence != null && occurrence.next != null;
    }
    
    public boolean hasNoOccurences() {
        return occurrence == null;
    }

    public abstract Cont copy(CopyContext context);
    public abstract void replace(TVar[] vars, Type[] replacements);
    
    public ContRef getOccurrence() {
        return occurrence;
    }
    
    public Cont createProxy(SSAFunction function, Val[] newParameters, Val[] oldParameters) {
        BoundVar[] proxyParameters = new BoundVar[oldParameters.length];
        for(int i=0;i<oldParameters.length;++i)
            proxyParameters[i] = new BoundVar(oldParameters[i].getType());
        SSABlock block = new SSABlock(proxyParameters);
        function.addBlock(block);
        block.setExit(new Jump(-1, createOccurrence(), 
                ValRef.concat(ValRef.createOccurrences(newParameters), 
                        ValRef.createOccurrences(proxyParameters))));
        return block;
    }
}
