package org.simantics.scl.compiler.elaboration.query.compilation;


public abstract class QueryConstraint {
    public int[] variables;
    public long finalBoundVariables;
    
    public QueryConstraint(int[] variables) {
        this.variables = variables;
    }
    
    public QueryConstraint() {
    }
    
    public long getVariableMask() {
        long result = 0L;
        for(int v : variables)
            result |= 1 << v;
        return result;
    }
    
    public abstract boolean canBeSolvedFrom(long boundVariables);
    public abstract double getSolutionCost(long boundVariables);
    public abstract double getSolutionBranching(long boundVariables);
    public abstract void generate(QueryCompilationContext context);
    
    public void generateAndUpdateCost(QueryCompilationContext context) {
        generate(context);
        context.updateCost(getSolutionBranching(finalBoundVariables), getSolutionCost(finalBoundVariables));
    }
}
