package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.common.exceptions.InternalCompilerError;
import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.internal.parsing.Symbol;

public abstract class Statement extends Symbol {

    public abstract Expression toExpression(EnvironmentalContext context, BlockType blockType, Expression in);
    public abstract void setLocationDeep(long loc);
    public abstract void resolvePattern(TranslationContext context);
    public abstract boolean mayBeRecursive();
    
    public Statement replace(ReplaceContext context) {
        throw new InternalCompilerError(getClass().getSimpleName() + " does not support replace.");
    }
    
    public Statement copy() {
        return replace(new ReplaceContext(null));
    }
    
    public abstract void accept(StatementVisitor visitor);
    public abstract StatementGroup getStatementGroup();
    
}
