package org.simantics.scl.compiler.elaboration.expressions.block;

import org.simantics.scl.compiler.elaboration.contexts.EnvironmentalContext;
import org.simantics.scl.compiler.elaboration.contexts.ReplaceContext;
import org.simantics.scl.compiler.elaboration.contexts.TranslationContext;
import org.simantics.scl.compiler.elaboration.expressions.EBind;
import org.simantics.scl.compiler.elaboration.expressions.ESimpleLet;
import org.simantics.scl.compiler.elaboration.expressions.EVariable;
import org.simantics.scl.compiler.elaboration.expressions.Expression;
import org.simantics.scl.compiler.elaboration.expressions.Variable;
import org.simantics.scl.compiler.errors.Locations;

public class GuardStatement extends Statement {
    public Expression value;
    
    public GuardStatement(Expression value) {
        this.value = value;
    }

    @Override
    public Expression toExpression(EnvironmentalContext context, BlockType blockType, Expression in) {
        if(blockType != BlockType.Normal) {
            Variable var = new Variable("_");
            return new EBind(location, blockType, new EVariable(location, var), value, in);
        }
        else
            return new ESimpleLet(location, null, value, in);
    }
    
    @Override
    public void setLocationDeep(long loc) {
        if(location == Locations.NO_LOCATION) {
            location = loc;
            value.setLocationDeep(loc);
        }
    }
    
    @Override
    public void resolvePattern(TranslationContext context) {
    }
    
    @Override
    public boolean mayBeRecursive() {
        return false;
    }
    
    @Override
    public Statement replace(ReplaceContext context) {
        return new GuardStatement(value.replace(context));
    }
    
    @Override
    public void accept(StatementVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public StatementGroup getStatementGroup() {
        return null;
    }
}
