package org.simantics.scl.compiler.constants.singletons;

import org.simantics.scl.compiler.constants.FunctionValue;
import org.simantics.scl.compiler.internal.codegen.references.Val;
import org.simantics.scl.compiler.internal.codegen.utils.MethodBuilder;
import org.simantics.scl.compiler.types.TVar;
import org.simantics.scl.compiler.types.Type;
import org.simantics.scl.compiler.types.Types;
import org.simantics.scl.compiler.types.kinds.Kinds;

public class BindingConstant extends FunctionValue {
    
    private static final TVar A = Types.var(Kinds.STAR);
    public static final BindingConstant INSTANCE = new BindingConstant();
    
    private BindingConstant() {
        super(new TVar[] {A}, Types.NO_EFFECTS, Types.apply(Types.BINDING, A), 
                Types.pred(Types.SERIALIZABLE, A));
    }
    
    @Override
    public Type applyExact(MethodBuilder mb, Val[] parameters) {
        mb.push(parameters[0], Types.BINDING);
        return getReturnType();
    }
}