package org.simantics.scl.compiler.common.precedence;


public final class Precedence {
    public static final Precedence DEFAULT = new Precedence(9, Associativity.NONASSOC);
    
    public final int level;
    public final Associativity associativity;

    public Precedence(int level, Associativity associativity) {
        this.level = level;
        this.associativity = associativity;
    }

    @Override
    public String toString() {
        if(associativity == Associativity.LEFT)
            return "infixl " + level;
        else if(associativity == Associativity.RIGHT)
            return "infixr " + level;
        else
            return "infix " + level;
    }
}
