/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.swing;

import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

import javax.swing.BorderFactory;
import javax.swing.JSlider;

import org.simantics.scenegraph.ExportableWidget.InputWidget;
import org.simantics.scenegraph.ExportableWidget.OutputWidget;

@OutputWidget({"value", "min", "max"})
@InputWidget("value")
public class SliderNode extends ComponentNode<JSlider> {
    private static final long serialVersionUID = 3161843367263793336L;
	protected transient ActionListener actionListener = null;

	// Necessary for widget ui:
    protected Integer value = 0;
    protected Integer min = 0;
    protected Integer max = 0;
    
    @ClientSide
    public void setValue(Integer value) {
        this.value = value;
    	if(component != null) {
    		if(!component.getValueIsAdjusting()) { // FIXME: propably does not work
//    			System.out.println("valueIsAdjusting == false");
    			component.setValue(value);
    		} else {
    			// TODO: cache value?
//    			System.out.println("valueIsAdjusting == true");    			
    		}
    	}
    }

    @Override
    public void init() {
        component = new JSlider();
        component.setPaintTicks(true);
		component.addMouseListener(new MouseListener() {

			@Override
			public void mouseClicked(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mousePressed(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mouseReleased(MouseEvent e) {
				if(component.getValueIsAdjusting())
					valueChanged(component.getValue());
			}

			@Override
			public void mouseEntered(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}

			@Override
			public void mouseExited(MouseEvent e) {
				// TODO Auto-generated method stub
				
			}});
        super.init();
    }
    
	@ServerSide
	protected void valueChanged(Integer value) {
		if(actionListener != null) { // FIXME: there might not be a component on the server side
	        ActionEvent e = new ActionEvent(component, ActionEvent.ACTION_PERFORMED, ""+value);
			actionListener.actionPerformed(e);
		}
	}
	
    public void setActionListener(ActionListener actionListener) {
        this.actionListener = actionListener;
    }

    @PropertySetter("Value Extent")
    @ClientSide
    public void setExtent(Integer extent) {
    	if(component != null)
	    	component.setExtent(extent);
    }
    
    @PropertySetter("Min Value")
    @ClientSide
    public void setMinimum(Integer min) {
        this.min = min;
    	if(component != null)
	    	component.setMinimum(min);
    }
    
    @PropertySetter("Max Value")
    @ClientSide
    public void setMaximum(Integer max) {
        this.max = max;
    	if(component != null)
    		component.setMaximum(max);
    }
    
    @ClientSide
    public void setOrientation(Integer orientation) {
    	if(component != null) {
    		component.setOrientation(orientation);
    	}
    }

    @ClientSide
	public void setTitle(String string) {
		if(component != null)
			component.setBorder(BorderFactory.createTitledBorder(string));
	}

    @PropertySetter("Major Tick Spacing")
    @ClientSide
	public void setMajorTickSpacing(Integer i) {
		if(component != null) {
			component.setLabelTable(component.createStandardLabels(i, component.getMinimum()));
			component.setMajorTickSpacing(i);
		}
	}

    @PropertySetter("Minor Tick Spacing")
    @ClientSide
	public void setMinorTickSpacing(Integer i) {
		if(component != null) {
			component.setMinorTickSpacing(i);
		}
	}

    @PropertySetter("Paint Ticks")
    @ClientSide
	public void setPaintTicks(Boolean b) {
		if(component != null) {
			component.setPaintTicks(b);
			component.updateUI();
		}
	}
    
    @PropertySetter("Paint Labels")
    @ClientSide
	public void setPaintLabels(Boolean b) {
		if(component != null)
			component.setPaintLabels(b);
	}
    
    @PropertySetter("Paint Track")
    @ClientSide
	public void setPaintTrack(Boolean b) {
		if(component != null)
			component.setPaintTrack(b);
	}
    
    @PropertySetter("Snap To Ticks")
    @ClientSide
	public void setSnapToTicks(Boolean b) {
		if(component != null)
			component.setSnapToTicks(b);
	}
    
    @PropertySetter("Inverted")
    @ClientSide
	public void setInverted(Boolean b) {
		if(component != null)
			component.setInverted(b);
	}
    
    @PropertySetter("Background Color")
    @ClientSide
	public void setBackgroundColor(Color color) {
    	// Not supported (For some reason this hides the slider)
	}
    
    public String widgetGet(String name) {
        if("value".equals(name)) {
            return ""+value;
        } else if("min".equals(name)) {
            return ""+min;
        } else if("max".equals(name)) {
            return ""+max;
        }
        return null;
    }
    
    public void widgetSet(String name, String value) {
        if("value".equals(name)) {
            this.value = Integer.parseInt(value);
            valueChanged(this.value);
        }
    }
}
