package org.simantics.scenegraph.g2d.events;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.lang.ref.WeakReference;

public class SGMouseEvent extends MouseEvent implements ISGMouseEvent {
	/**
	 * 
	 */
	private static final long serialVersionUID = 1L;

	private double _x;
	private double _y;
	private WeakReference<MouseEvent> _orig;
	
	public SGMouseEvent(Component source, int id, long when, int modifiers,
			int x, int y, int xAbs, int yAbs, int clickCount,
			boolean popupTrigger, int button, MouseEvent orig) {
		super(source, id, when, modifiers, x, y, xAbs, yAbs, clickCount, popupTrigger,
				button);
		this._x = x;
		this._y = y;
		this._orig = new WeakReference<MouseEvent>(orig);
	}

	public SGMouseEvent(Component source, int id, long when, int modifiers,
			int x, int y, int clickCount, boolean popupTrigger, int button, MouseEvent orig) {
		super(source, id, when, modifiers, x, y, clickCount, popupTrigger, button);
		this._x = x;
		this._y = y;
		this._orig = new WeakReference<MouseEvent>(orig);
	}

	public SGMouseEvent(Component source, int id, long when, int modifiers,
			int x, int y, int clickCount, boolean popupTrigger, MouseEvent orig) {
		super(source, id, when, modifiers, x, y, clickCount, popupTrigger);
		this._x = x;
		this._y = y;
		this._orig = new WeakReference<MouseEvent>(orig);
	}

	public SGMouseEvent(Component source, int id, long when, int modifiers,
			double x, double y, int xAbs, int yAbs, int clickCount,
			boolean popupTrigger, int button, MouseEvent orig) {
		super(source, id, when, modifiers, (int)x, (int)y, xAbs, yAbs, clickCount, popupTrigger,
				button);
		this._x = x;
		this._y = y;
		this._orig = new WeakReference<MouseEvent>(orig);
	}

	public SGMouseEvent(Component source, int id, long when, int modifiers,
			double x, double y, int clickCount, boolean popupTrigger, int button, MouseEvent orig) {
		super(source, id, when, modifiers, (int)x, (int)y, clickCount, popupTrigger, button);
		this._x = x;
		this._y = y;
		this._orig = new WeakReference<MouseEvent>(orig);
	}

	public SGMouseEvent(Component source, int id, long when, int modifiers,
			double x, double y, int clickCount, boolean popupTrigger, MouseEvent orig) {
		super(source, id, when, modifiers, (int)x, (int)y, clickCount, popupTrigger);
		this._x = x;
		this._y = y;
		this._orig = new WeakReference<MouseEvent>(orig);
	}
	
	public double getDoubleX() {
		return _x;
	}
	
	public double getDoubleY() {
		return _y;
	}
	
	@Override
	public void consume() {
		MouseEvent e =_orig.get();
		if(e != null)
			e.consume();
		super.consume();
	}
	
	@Override
	public boolean isConsumed() {
		MouseEvent e =_orig.get();
		if(e != null)
			return e.isConsumed();
		return super.isConsumed();
	}
}
