/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.g2d;

import java.awt.Component;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;

/**
 * @author Tuukka Lehtonen
 * See {@link G2DPDFRenderingHints}
 */
public final class G2DRenderingHints {

    public static final Key KEY_BEGIN_ELEMENT = new G2DRenderingHints.Key(0);
    public static final Key KEY_END_ELEMENT = new G2DRenderingHints.Key(1);
    public static final Key KEY_ELEMENT_ID = new G2DRenderingHints.Key(2);

    public static class Key extends java.awt.RenderingHints.Key {

        public Key(int privateKey) {
            super(privateKey);    
        }
    
        @Override
        public boolean isCompatibleValue(Object val) {
            switch (intKey()) {
                case 0:
                    return val == null || val instanceof String 
                            || val instanceof Map;
                case 1:
                    return val == null || val instanceof Object;
                case 2:
                    return val == null || val instanceof Object;
                default:
                    throw new RuntimeException("Not possible!");
            }
        }
    }
	
    /**
     * A rendering hint for storing the boundaries of the control area within a
     * Graphics2D instance.
     */
    public static final Key KEY_CONTROL_BOUNDS = new Key(1000) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Rectangle2D;
        }
    };

    /**
     * A rendering hint for storing the root AWT Component on which the scene
     * graph is rendered within a Graphics2D instance.
     */
    public static final Key KEY_COMPONENT      = new Key(1001) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Component;
        }
    };

    /**
     * If this hint is not specified, the default interpretation should be
     * {@value #AS_PATHS}.
     * 
     * @since 1.31.0
     */
    public static enum TextRenderingMode {
        AS_PATHS,
        AS_TEXT
    }

    /**
     * A rendering hint for telling text rendering Simantics G2D scene graph node
     * implementations how to render the text: as text or paths.
     * 
     * @since 1.31.0
     */
    public static final Key KEY_TEXT_RENDERING_MODE = new Key(2004) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof TextRenderingMode;
        }
    };

    /**
     * Instead of rendering SVGNode using SVG Salamander pass it to G2D as SVGPassthruShape in String format.
     * 
     * @since 1.31.0
     */
    public static final Key KEY_SVG_PASSTHRU = new Key(2005) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof Boolean;
        }
    };

    /**
     * The current Graphics2D AffineTransform for all nodes under the special
     * spatialRoot : RTreeNode.
     * 
     * This can be used to optimize the creation and of new AffineTransforms by
     * not having to use Graphics2D.getTransform to retrieve the current
     * transformation which always creates new instances.
     */
    public static final Key KEY_TRANSFORM_UNDER_SPATIAL_ROOT = new Key(2006) {
        @Override
        public boolean isCompatibleValue(Object val) {
            return val instanceof AffineTransform || val == null;
        }
    };

}