/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.scenegraph.profile.request;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.common.NamedResource;
import org.simantics.db.common.request.ResourceRead;
import org.simantics.db.exception.DatabaseException;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.scenegraph.profile.ProfileUtils;

/**
 * @author Antti Villberg
 */
public class RuntimeProfileActiveEntryResources extends ResourceRead<Collection<Resource>> {

    public RuntimeProfileActiveEntryResources(Resource resource) {
        super(resource);
    }
    
    @Override
    public Collection<Resource> perform(ReadGraph graph) throws DatabaseException {
        DiagramResource DIA = DiagramResource.getInstance(graph);

        ArrayList<Resource> result = new ArrayList<Resource>();
        
        result.addAll(graph.syncRequest(new ProfileEntryContributions(resource)));

        Resource activeProfile = graph.getPossibleObject(resource, DIA.RuntimeDiagram_HasRuntimeProfile);
        if (activeProfile == null) {
        	
        	List<NamedResource> available = graph.syncRequest(new AvailableProfiles(resource));
        	if(available.size() != 1) return result;
        	
        	activeProfile = available.iterator().next().getResource();
            
        }
        
        Resource rootEntries = graph.getPossibleObject(activeProfile, DIA.HasEntries);
        if (rootEntries == null)
            return result;
        
        if(graph.isImmutable(activeProfile)) {
        	Resource activationState = ProfileUtils.getPossibleProfileActivationState(graph, resource, activeProfile);
        	if(activationState != null) {
	        	result.addAll(graph.syncRequest(new ProfileActiveEntryResources(activationState, rootEntries)));
        	}
        } else {
        	result.addAll(graph.syncRequest(new ProfileActiveEntryResources(activeProfile, rootEntries)));
        }
        
        return result;
        
    }

}
