/*******************************************************************************
 * Copyright (c) 2007 VTT Technical Research Centre of Finland and others.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.management;

import org.eclipse.core.runtime.preferences.AbstractPreferenceInitializer;
import org.eclipse.core.runtime.preferences.DefaultScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.simantics.project.internal.Activator;
import org.simantics.utils.strings.EString;

public class RepositoryPreference extends AbstractPreferenceInitializer {

    public static final String        P_REPOSITY_SOURCES = "repository_sources";

    public RepositoryPreference() {
    }

    @Override
    public void initializeDefaultPreferences() {
        IEclipsePreferences prefs = DefaultScope.INSTANCE.getNode(Activator.PLUGIN_ID);
        String[] xxx = new String[] {"http://www.simantics.org/update"};
        prefs.put(P_REPOSITY_SOURCES, EString.implode(xxx));

        /*
        IScopeContext context = new DefaultScope();
        Preferences node = context.getNode(WorkspaceActivator.PLUGIN_ID);

        String[] xxx = new String[] {"http://www.simantics.org/update"};
        Binding bbb = Bindings.getBindingUnchecked(String[].class);
        String yyy = (String) Bindings.STR_VARIANT.createUnchecked(bbb, xxx);
        node.put(P_REPOSITY_SOURCES, yyy);
         */
    }

}

