/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.project.features.registry;

/**
 * @author Tuukka Lehtonen
 */
public class InjectedDependency {

	public final ProjectFeatureReference from;
	public final ProjectFeatureReference to;

	public InjectedDependency(ProjectFeatureReference from, ProjectFeatureReference to) {
		if (from == null)
			throw new NullPointerException("null from reference");
		if (to == null)
			throw new NullPointerException("null to reference");
		this.from = from;
		this.to = to;
	}

	@Override
	public String toString() {
		return from + " -> " + to;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = 1;
		result = prime * result + from.hashCode();
		result = prime * result + to.hashCode();
		return result;
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (obj == null)
			return false;
		if (getClass() != obj.getClass())
			return false;
		InjectedDependency other = (InjectedDependency) obj;
		return from.equals(other.from) && to.equals(other.to);
	}

}
