/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.rules;

import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.rules.domain.IDomainAccessor;
import org.simantics.objmap.graph.rules.range.IRangeAccessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MappedElementRule<Domain, Range>
implements IBidirectionalMappingRule<Domain, Range> {
    static final Logger LOGGER = LoggerFactory.getLogger(MappedElementRule.class);
    IDomainAccessor<Domain, Domain> domainAccessor;
    IRangeAccessor<Range, Range> rangeAccessor;

    public MappedElementRule(IDomainAccessor<Domain, Domain> domainAccessor, IRangeAccessor<Range, Range> rangeAccessor) {
        this.domainAccessor = domainAccessor;
        this.rangeAccessor = rangeAccessor;
    }

    @Override
    public boolean updateDomain(WriteGraph g, IBackwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
        LOGGER.trace("    MappedElementRule.updateDomain");
        Range value = this.rangeAccessor.get(rangeElement);
        Object mappedValue = value == null ? null : (Object)map.inverseMap(g, value);
        return this.domainAccessor.set(g, domainElement, mappedValue);
    }

    @Override
    public boolean updateRange(ReadGraph g, IForwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
        LOGGER.trace("    MappedElementRule.updateRange");
        Domain value = this.domainAccessor.get(g, domainElement);
        Object mappedValue = value == null ? null : (Object)map.map(g, value);
        return this.rangeAccessor.set(rangeElement, mappedValue);
    }

    @Override
    public void createDomain(WriteGraph g, IBackwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
        this.updateDomain(g, map, domainElement, rangeElement);
    }

    @Override
    public void createRange(ReadGraph g, IForwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
        this.updateRange(g, map, domainElement, rangeElement);
    }
}

