/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.objmap.graph.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.rules.factory.IMethodRuleFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpdateMethodFactory<Domain, Range>
implements IMethodRuleFactory<Domain, Range> {
    static Logger LOGGER = LoggerFactory.getLogger(UpdateMethodFactory.class);

    @Override
    public IBidirectionalMappingRule<Domain, Range> create(ReadGraph g, Annotation annotation, final Method method) throws DatabaseException {
        method.setAccessible(true);
        return new IBidirectionalMappingRule<Domain, Range>(){

            @Override
            public boolean updateRange(ReadGraph g, IForwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
                LOGGER.trace("    UpdateMethodFactory.updateRange");
                try {
                    return (Boolean)method.invoke(rangeElement, g, domainElement);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return false;
                }
            }

            @Override
            public boolean updateDomain(WriteGraph g, IBackwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
                return false;
            }

            @Override
            public void createDomain(WriteGraph g, IBackwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
                this.updateDomain(g, map, domainElement, rangeElement);
            }

            @Override
            public void createRange(ReadGraph g, IForwardMapping<Domain, Range> map, Domain domainElement, Range rangeElement) throws MappingException {
                this.updateRange(g, map, domainElement, rangeElement);
            }
        };
    }
}

