/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.schema;

//import org.slf4j.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.schema.ILinkType;
import org.simantics.objmap.structural.IStructuralObject;
import org.simantics.objmap.structural.StructuralResource;

/**
 * A link type that is associated with adaptable resource (ReadGraph.getAdapter(Resource,Class)). 
 * The adapted object must implement IAdaptable interface for returning the original Resource. 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class AdaptedLinkType implements ILinkType<StructuralResource,IStructuralObject> {

	
	//static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
    Resource domainType;
    Class<?> rangeType;
    
    
    public AdaptedLinkType(Resource domainType, Class<?> rangeType) {
        this.domainType = domainType;
        this.rangeType = rangeType;
    }
    
    @Override
    public StructuralResource createDomainElement(WriteGraph g, IStructuralObject rangeElement)
    		throws MappingException {
    	try {
    		IAdaptable adaptable = (IAdaptable)rangeElement;
    		Resource res = (Resource)adaptable.getAdapter(Resource.class);
    		if (res == null)
    			throw new NullPointerException();
    		return new StructuralResource(g,res);
    	} catch (Exception e) {
    		throw new MappingException("Adapted object must implement IAdaptable interface to return the source Resource.", e);
    	}
    	
    }

    
    @Override
    public IStructuralObject createRangeElement(ReadGraph g, StructuralResource domainElement)
    		throws MappingException {
    	try {
    		// FIXME : this will not work, we cannot assume that adapted objects would implement IStructuralObject interface.
    		return (IStructuralObject)g.adapt(domainElement.getResource(), rangeType);
    	} catch (DatabaseException e) {
    		throw new MappingException(e);
    	}
    }
    
    public void createDomain(WriteGraph graph, IBackwardMapping<StructuralResource, IStructuralObject> mapping, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
    	
    };
    
    public void createRange(ReadGraph graph, org.simantics.objmap.forward.IForwardMapping<StructuralResource, IStructuralObject> mapping, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
    	
    };
    
    public boolean updateDomain(WriteGraph g, IBackwardMapping<StructuralResource, IStructuralObject> map, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
    	return false;
    }
    
    public boolean updateRange(ReadGraph g, IForwardMapping<StructuralResource, IStructuralObject> map, StructuralResource domainElement, IStructuralObject rangeElement) throws MappingException {
    	return false;
    }
}
