/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.annotations.factories;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.simantics.db.ReadGraph;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.rules.factory.IMethodRuleFactory;

public class UpdateMethodFactory<Domain, Range> implements IMethodRuleFactory<Domain, Range> {

    static Logger LOGGER = LoggerFactory.getLogger(UpdateMethodFactory.class);
    
    @Override
    public IBidirectionalMappingRule<Domain, Range> create(ReadGraph g, 
            Annotation annotation, 
            final Method method)
            throws DatabaseException {
        method.setAccessible(true);
        return new IBidirectionalMappingRule<Domain,Range>() {
            
            @Override
            public boolean updateRange(ReadGraph g, IForwardMapping<Domain, Range> map,
                    Domain domainElement, Range rangeElement)
                    throws MappingException {
                LOGGER.trace("    UpdateMethodFactory.updateRange");      
                try {
                    return (Boolean)method.invoke(rangeElement, g, domainElement);
                } catch (Exception e) {
                    // TODO Auto-generated catch block
                    e.printStackTrace();
                }
                return false;
            }
            
            @Override
            public boolean updateDomain(WriteGraph g, IBackwardMapping<Domain,Range> map,
                    Domain domainElement, Range rangeElement)
                    throws MappingException {
                return false;
            }
            
            public void createDomain(WriteGraph g, IBackwardMapping<Domain,Range> map, Domain domainElement, Range rangeElement) throws MappingException {
            	updateDomain(g, map, domainElement, rangeElement);
            };
            
            public void createRange(ReadGraph g, IForwardMapping<Domain,Range> map, Domain domainElement, Range rangeElement) throws MappingException {
            	updateRange(g, map, domainElement, rangeElement);
            };
        };
    }

}
