/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.structural.annotations.factories;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.layer0.Layer0;

public class DataTypeUtils {
    
    public static Resource dataTypeOfClass(ReadGraph g, Class<?> clazz) {
        Layer0 b = Layer0.getInstance(g);
        if(clazz.equals(Double.class) || clazz.equals(double.class))
            return b.Double;
        else if(clazz.equals(String.class))
            return b.String;
        else if(clazz.equals(Integer.class) || clazz.equals(int.class))
            return b.Integer;
        else if(clazz.equals(Float.class) || clazz.equals(float.class))
            return b.Float;
        else if(clazz.equals(Boolean.class) || clazz.equals(boolean.class))
            return b.Boolean;
        else if(clazz.equals(Long.class) || clazz.equals(long.class))
            return b.Long;
        else if(clazz.equals(Byte.class) || clazz.equals(byte.class))
            return b.Byte;
        
        else if(clazz.equals(double[].class))
            return b.DoubleArray;
        else if(clazz.equals(int[].class))
            return b.IntegerArray;
        else if(clazz.equals(byte[].class))
            return b.ByteArray;
        else if(clazz.equals(float[].class))
            return b.FloatArray;
        else if(clazz.equals(boolean[].class))
            return b.BooleanArray;
        else if(clazz.equals(String[].class))
            return b.StringArray;
        else if(clazz.equals(long[].class))
            return b.LongArray;
        else {
        	System.out.println("Couldn't find a data type for " + clazz);
            return null;
        }
    }
    
}
