/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.schema;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;

import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.layer0.Layer0;
import org.simantics.objmap.bidirectional.IBidirectionalMappingRule;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.graph.annotations.GetType;
import org.simantics.objmap.graph.annotations.SetType;

public class DynamicSimpleLinkType<Range> extends SimpleLinkType<Range>{

	protected Method typeGetter;
	protected Method typeSetter;
	
	public DynamicSimpleLinkType(Resource domainType, Class<?> rangeType, ArrayList<IBidirectionalMappingRule<Resource, Range>> rules) {
		super(domainType, rangeType, rules);
		findTypeGetter(rangeType);
	}

	public DynamicSimpleLinkType(Resource domainType, Class<?> rangeType) {
		super(domainType, rangeType);
		findTypeGetter(rangeType);
	}
	
	private void findTypeGetter(Class<?> clazz) {
		for (Method m : clazz.getDeclaredMethods()) {
			 m.setAccessible(true);
			 GetType t = m.getAnnotation(GetType.class);
			 if (t != null) {
				 typeGetter = m;
			 }
			 SetType t2 = m.getAnnotation(SetType.class);
			 if (t2 != null) {
				 typeSetter = m;
			 }
		}
		if (typeGetter == null || typeSetter == null) {
			Class<?> superClazz = clazz.getSuperclass();
			if (superClazz != Object.class)
				findTypeGetter(superClazz);
			if (typeGetter == null || typeSetter == null) {
				throw new RuntimeException("Cannot find dynamic type methods for class " + clazz.getSimpleName());	
			}
		}
		
			
	}
	
	@Override
    public Resource createDomainElement(WriteGraph g, Range rangeElement)
            throws MappingException {
        try {
        	String typeUri = (String)typeGetter.invoke(rangeElement, (Object[]) null);
            if(LOGGER.isTraceEnabled())
                LOGGER.trace("SimpleLinkType.createDomainElement " +
                        rangeElement.toString()
                );
            Resource actualDomainType = g.getResource(typeUri);
            Resource result = g.newResource();
            //g.claim(result, Layer0.getInstance(g).InstanceOf, null, domainType);
            g.claim(result, Layer0.getInstance(g).InstanceOf, null, actualDomainType);
            return result;
        } catch(DatabaseException e) {
            throw new MappingException(e);
        } catch (IllegalArgumentException e) {
        	 throw new MappingException(e);
		} catch (IllegalAccessException e) {
			 throw new MappingException(e);
		} catch (InvocationTargetException e) {
			 throw new MappingException(e.getCause());
		}
    }
	
	 @SuppressWarnings("unchecked")
	@Override
	    public Range createRangeElement(ReadGraph g, Resource domainElement)
	            throws MappingException {
	        try {
	            if(LOGGER.isTraceEnabled())
	                try { 
	                    LOGGER.trace("SimpleLinkType.createRangeElement " +
	                    		NameUtils.getSafeName(g, domainElement)
	                            );
	                } catch(DatabaseException e) {
	                    throw new MappingException(e);
	                }
	           Range r =  (Range)rangeType.newInstance();
	           Resource type = g.getSingleType(domainElement, domainType);
	           String uri = g.getURI(type);
	           typeSetter.invoke(r, uri);
	           return r;
	        } catch (InstantiationException e) {
	            throw new MappingException(e);
	        } catch (IllegalAccessException e) {
	            throw new MappingException(e);
	        } catch (DatabaseException e) {
	        	throw new MappingException(e);
			} catch (IllegalArgumentException e) {
				throw new MappingException(e);
			} catch (InvocationTargetException e) {
				throw new MappingException(e.getCause());
			} 
	    }

}
