/*******************************************************************************
 * Copyright (c) 2012, 2013 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.schema;

//import org.slf4j.Logger;
import org.eclipse.core.runtime.IAdaptable;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.exception.DatabaseException;

import org.simantics.objmap.backward.IBackwardMapping;
import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;

/**
 * A link type that is associated with adaptable resource (ReadGraph.getAdapter(Resource,Class)). 
 * The adapted object must implement IAdaptable interface for returning the original Resource. 
 * 
 * @author Marko Luukkainen <marko.luukkainen@vtt.fi>
 *
 */
public class AdaptedLinkType<Range> implements ILinkType<Resource,Range> {

	
	//static Logger LOGGER = Logger.getLogger("org.simantics.objmap");
    
    Resource domainType;
    Class<?> rangeType;
    
    
    public AdaptedLinkType(Resource domainType, Class<?> rangeType) {
        this.domainType = domainType;
        this.rangeType = rangeType;
    }
    
    @Override
    public Resource createDomainElement(WriteGraph g, Range rangeElement)
    		throws MappingException {
    	try {
    		IAdaptable adaptable = (IAdaptable)rangeElement;
    		Resource res = (Resource)adaptable.getAdapter(Resource.class);
    		if (res == null)
    			throw new NullPointerException();
    		return res;
    	} catch (Exception e) {
    		throw new MappingException("Adapted object must implement IAdaptable interface to return the source Resource.", e);
    	}
    	
    }
    
    @SuppressWarnings("unchecked")
	@Override
    public Range createRangeElement(ReadGraph g, Resource domainElement)
    		throws MappingException {
    	try {
    		return (Range)g.adapt(domainElement, rangeType);
    	} catch (DatabaseException e) {
    		throw new MappingException(e);
    	}
    }
    
    public void createDomain(WriteGraph graph, IBackwardMapping<Resource,Range> mapping, Resource domainElement, Range rangeElement) throws MappingException {
    	
    };
    
    public void createRange(ReadGraph graph, org.simantics.objmap.forward.IForwardMapping<Resource,Range> mapping, Resource domainElement, Range rangeElement) throws MappingException {
    	
    };
    
    public boolean updateDomain(WriteGraph g, IBackwardMapping<Resource,Range> map, Resource domainElement, Range rangeElement) throws MappingException {
    	return false;
    }
    
    public boolean updateRange(ReadGraph g, IForwardMapping<Resource,Range> map, Resource domainElement, Range rangeElement) throws MappingException {
    	return false;
    }
}
