/*******************************************************************************
 * Copyright (c) 2007, 2013 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.objmap.graph.impl;

import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.procedure.SyncListener;
import org.simantics.db.request.Read;

import org.simantics.objmap.exceptions.MappingException;
import org.simantics.objmap.forward.IForwardMapping;
import org.simantics.objmap.graph.impl.Link;


public class RangeUpdateRequest<Domain,Range> implements Read<Boolean>, SyncListener<Boolean> {

    Link<Domain,Range> link;
    /*
     * Note that this map uses a read request that it has got from caller and 
     * not the one that is used in updateRange. This is intentional.
     */
    IForwardMapping<Domain, Range> map; // map==null is used to flag that request is performed once
    Mapping<Domain, Range> mapping; // mapping==null is used as a flag the request disposed
    
    public RangeUpdateRequest(Link<Domain,Range> link, IForwardMapping<Domain,Range> map, Mapping<Domain,Range> mapping) {
        this.link = link;
        this.map = map;
        this.mapping = mapping;
    }

    @Override
    public Boolean perform(ReadGraph g) throws DatabaseException {
        if(map != null) {
            link.type.updateRange(g, map, link.domainElement, link.rangeElement);
            map = null;
            return Boolean.TRUE;
        }
        else if(mapping != null) {
            mapping.domainModified(link);
            mapping = null;
            return Boolean.FALSE;
        }
        else
            return null;
    }
    
    @Override
    public void exception(ReadGraph graph, Throwable throwable)
            throws DatabaseException {
        if(throwable instanceof DatabaseException)
            throw (DatabaseException)throwable;
        else
            throw new MappingException(throwable);
    }

    @Override
    public void execute(ReadGraph graph, Boolean result)
            throws DatabaseException {       
    }

    @Override
    public boolean isDisposed() {
        return mapping == null || link.removed || mapping.isDisposed();
    }
    
    
    
}
