/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.Map;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.menus.UIElement;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.layers.ILayersEditor;
import org.simantics.modeling.ui.diagramEditor.DiagramEditor;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class ToggleFocusabilityHandler
extends AbstractHandler
implements IElementUpdater {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ILayersEditor le = this.getLayers();
        if (le != null) {
            boolean b = le.getIgnoreFocusSettings();
            le.setIgnoreFocusSettings(!b);
            ICommandService service = (ICommandService)PlatformUI.getWorkbench().getService(ICommandService.class);
            service.refreshElements(event.getCommand().getId(), null);
        }
        return null;
    }

    public void updateElement(UIElement element, Map parameters) {
        ILayersEditor le;
        DiagramEditor editor = this.getEditor();
        if (editor != null && (le = this.getLayers(editor)) != null) {
            boolean bool = le.getIgnoreFocusSettings();
            element.setChecked(bool);
            element.setTooltip(String.valueOf(bool ? "Deny" : "Allow") + " Focusing and Editing of Images");
            return;
        }
    }

    protected ILayersEditor getLayers() {
        DiagramEditor editor = this.getEditor();
        if (editor == null) {
            return null;
        }
        return this.getLayers(editor);
    }

    protected ILayersEditor getLayers(DiagramEditor editor) {
        IDiagram diagram = editor.getAdapter(IDiagram.class);
        if (diagram == null) {
            return null;
        }
        ILayersEditor le = (ILayersEditor)diagram.getHint(DiagramHints.KEY_LAYERS_EDITOR);
        return le;
    }

    protected DiagramEditor getEditor() {
        IEditorPart editorPart = WorkbenchUtils.getActiveEditor();
        if (editorPart == null) {
            return null;
        }
        if (editorPart instanceof DiagramEditor) {
            DiagramEditor editor = (DiagramEditor)editorPart;
            return editor;
        }
        return null;
    }
}

