/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor.handlers;

import java.util.ArrayList;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.request.Write;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.ui.utils.ResourceAdaptionUtils;

public class AlignHorizontalHandler
extends AbstractHandler {
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection s = HandlerUtil.getCurrentSelectionChecked((ExecutionEvent)event);
        final Resource[] resources = ResourceAdaptionUtils.toResources((Object)s);
        if (resources.length < 2) {
            return null;
        }
        SimanticsUI.getSession().asyncRequest((Write)new WriteRequest(){

            public void perform(WriteGraph graph) throws DatabaseException {
                DiagramResource dr = DiagramResource.getInstance((ReadGraph)graph);
                ArrayList<Resource> elements = new ArrayList<Resource>();
                ArrayList<double[]> transforms = new ArrayList<double[]>();
                Resource[] resourceArray = resources;
                int n = resources.length;
                int n2 = 0;
                while (n2 < n) {
                    double[] transform;
                    Resource r = resourceArray[n2];
                    if (graph.isInstanceOf(r, dr.Element) && !graph.isInstanceOf(r, dr.Connection) && (transform = (double[])graph.getPossibleRelatedValue(r, dr.HasTransform)) != null) {
                        elements.add(r);
                        transforms.add(transform);
                    }
                    ++n2;
                }
                double mx = 0.0;
                double my = 0.0;
                for (double[] t : transforms) {
                    mx += t[4];
                    my += t[5];
                }
                mx /= (double)transforms.size();
                my /= (double)transforms.size();
                int count = 0;
                for (double[] t : transforms) {
                    if (!(Math.abs(t[4] - mx) < 0.1)) continue;
                    ++count;
                }
                if (count > 1) {
                    return;
                }
                int i = 0;
                while (i < transforms.size()) {
                    Resource element = (Resource)elements.get(i);
                    double[] t = (double[])transforms.get(i);
                    graph.claimLiteral(element, dr.HasTransform, (Object)new double[]{t[0], t[1], t[2], t[3], t[4], my});
                    ++i;
                }
            }
        });
        return null;
    }
}

