/*
 * Decompiled with CFR 0.152.
 */
package org.simantics.modeling.ui.diagramEditor;

import java.awt.Point;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IWorkbenchPartSite;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.RequestProcessor;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.PossibleIndexRoot;
import org.simantics.db.common.request.ResourceRead2;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.common.utils.NameUtils;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.IsLinkedTo;
import org.simantics.db.layer0.util.Layer0Utils;
import org.simantics.db.layer0.variable.Variable;
import org.simantics.db.layer0.variable.Variables;
import org.simantics.db.request.Read;
import org.simantics.db.request.Write;
import org.simantics.db.service.SerialisationSupport;
import org.simantics.diagram.adapter.GraphToDiagramSynchronizer;
import org.simantics.diagram.content.Change;
import org.simantics.diagram.content.DiagramContentChanges;
import org.simantics.diagram.content.DiagramContentTracker;
import org.simantics.diagram.stubs.DiagramResource;
import org.simantics.diagram.symbollibrary.ISymbolItem;
import org.simantics.diagram.synchronization.runtime.DiagramSelectionUpdater;
import org.simantics.diagram.ui.DiagramModelHints;
import org.simantics.diagram.ui.ElementClassTransferable;
import org.simantics.g2d.canvas.ICanvasContext;
import org.simantics.g2d.canvas.impl.DependencyReflection;
import org.simantics.g2d.diagram.DiagramHints;
import org.simantics.g2d.diagram.DiagramUtils;
import org.simantics.g2d.diagram.IDiagram;
import org.simantics.g2d.diagram.handler.PickContext;
import org.simantics.g2d.diagram.handler.PickRequest;
import org.simantics.g2d.diagram.participant.AbstractDiagramParticipant;
import org.simantics.g2d.dnd.DnDHints;
import org.simantics.g2d.dnd.ElementClassDragItem;
import org.simantics.g2d.dnd.IDnDContext;
import org.simantics.g2d.dnd.IDragItem;
import org.simantics.g2d.dnd.IDropTargetParticipant;
import org.simantics.g2d.element.ElementClass;
import org.simantics.g2d.element.ElementHints;
import org.simantics.g2d.element.ElementUtils;
import org.simantics.g2d.element.IElement;
import org.simantics.g2d.participant.TransformUtil;
import org.simantics.modeling.ModelingResources;
import org.simantics.modeling.ui.Activator;
import org.simantics.modeling.ui.diagramEditor.WSEDragItem;
import org.simantics.scenegraph.g2d.snap.ISnapAdvisor;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.ui.dnd.LocalObjectTransfer;
import org.simantics.ui.dnd.LocalObjectTransferable;
import org.simantics.ui.selection.WorkbenchSelectionElement;
import org.simantics.utils.logging.TimeLogger;
import org.simantics.utils.ui.workbench.WorkbenchUtils;

public class PopulateElementDropParticipant
extends AbstractDiagramParticipant
implements IDropTargetParticipant {
    @DependencyReflection.Dependency
    PickContext pickContext;
    @DependencyReflection.Dependency
    TransformUtil transformUtil;
    protected GraphToDiagramSynchronizer synchronizer;
    protected IWorkbenchPartSite partSite;

    public PopulateElementDropParticipant(GraphToDiagramSynchronizer synchronizer) {
        this(synchronizer, null);
    }

    public PopulateElementDropParticipant(GraphToDiagramSynchronizer synchronizer, IWorkbenchPartSite partSite) {
        this.synchronizer = synchronizer;
        this.partSite = partSite;
    }

    public void dragEnter(DropTargetDragEvent dtde, IDnDContext dp) {
        if (this.diagram == null) {
            return;
        }
        Transferable tr = dtde.getTransferable();
        if (tr.isDataFlavorSupported(LocalObjectTransferable.FLAVOR)) {
            IStructuredSelection sel;
            Object obj = null;
            try {
                obj = tr.getTransferData(LocalObjectTransferable.FLAVOR);
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            if (!(obj instanceof IStructuredSelection)) {
                obj = LocalObjectTransfer.getTransfer().getObject();
            }
            if (obj instanceof IStructuredSelection && !(sel = (IStructuredSelection)obj).isEmpty()) {
                for (Object elm : sel.toList()) {
                    if (!(elm instanceof IAdaptable)) continue;
                    ElementClass ec = (ElementClass)((IAdaptable)elm).getAdapter(ElementClass.class);
                    if (ec != null) {
                        dp.add((Object)new ElementClassDragItem(ec));
                        continue;
                    }
                    Resource r = (Resource)((IAdaptable)elm).getAdapter(Resource.class);
                    if (r == null) continue;
                    boolean cfr_ignored_0 = elm instanceof ISymbolItem;
                    try {
                        Object errorOrSymbolResource = this.validateDrop((RequestProcessor)this.synchronizer.getSession(), r, (Resource)this.diagram.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE));
                        if (!(errorOrSymbolResource instanceof Resource)) continue;
                        ElementClassDragItem item = new ElementClassDragItem(this.synchronizer.getNodeClass((Resource)errorOrSymbolResource));
                        item.getHintContext().setHint(ElementHints.KEY_TRANSFORM, (Object)AffineTransform.getScaleInstance(1.0, 1.0));
                        dp.add((Object)item);
                    }
                    catch (DatabaseException databaseException) {}
                }
                dp.getHints().removeHint(DnDHints.KEY_DND_GRID_COLUMNS);
            }
            return;
        }
        if (tr.isDataFlavorSupported(ElementClassTransferable.FLAVOR)) {
            ElementClassTransferable.ResourceElementClassTransferData dada;
            try {
                dada = (ElementClassTransferable.ResourceElementClassTransferData)tr.getTransferData(ElementClassTransferable.FLAVOR);
            }
            catch (UnsupportedFlavorException e) {
                throw new Error(e);
            }
            catch (IOException e) {
                throw new Error(e);
            }
            Session s = this.synchronizer.getSession();
            try {
                String[] stringArray = dada.elementClassResourceRandomAccessReference;
                int n = dada.elementClassResourceRandomAccessReference.length;
                int n2 = 0;
                while (n2 < n) {
                    String rid = stringArray[n2];
                    SerialisationSupport support = (SerialisationSupport)s.getService(SerialisationSupport.class);
                    Resource r = support.getResource(Long.parseLong(rid));
                    dp.add((Object)new ElementClassDragItem(this.synchronizer.getNodeClass(r)));
                    ++n2;
                }
            }
            catch (DatabaseException e) {
                throw new RuntimeException(e);
            }
            return;
        }
    }

    private Object validateDrop(RequestProcessor processor, final Resource draggedResource, final Resource dropTarget) throws DatabaseException {
        return processor.syncRequest((Read)new UniqueRead<Object>(){

            public Object perform(ReadGraph graph) throws DatabaseException {
                Resource componentTypeFromDiagram;
                Resource componentType;
                Resource componentTypeFromDiagram2;
                Resource sourceModel = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(draggedResource));
                Resource targetModel = (Resource)graph.syncRequest((Read)new PossibleIndexRoot(dropTarget));
                if (sourceModel != null && !((Boolean)graph.syncRequest((Read)new IsLinkedTo(targetModel, sourceModel))).booleanValue()) {
                    return "Cannot instantiate " + NameUtils.getSafeName((ReadGraph)graph, (Resource)draggedResource) + " into model " + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)targetModel) + ". The source namespace (" + NameUtils.getURIOrSafeNameInternal((ReadGraph)graph, (Resource)sourceModel) + ") is not linked to the target model.";
                }
                ModelingResources MOD = ModelingResources.getInstance((ReadGraph)graph);
                StructuralResource2 STR = StructuralResource2.getInstance((ReadGraph)graph);
                Resource configuration = graph.getPossibleObject(dropTarget, MOD.DiagramToComposite);
                if (configuration != null && (componentTypeFromDiagram2 = graph.getPossibleObject(configuration, STR.Defines)) != null && Layer0Utils.isPublished((ReadGraph)graph, (Resource)componentTypeFromDiagram2)) {
                    return "Cannot create elements into a diagram that belongs to a published user component.";
                }
                Resource symbol = graph.getPossibleObject(draggedResource, MOD.ComponentTypeToSymbol);
                if (symbol != null) {
                    componentType = draggedResource;
                } else {
                    componentType = graph.getPossibleObject(draggedResource, MOD.SymbolToComponentType);
                    symbol = draggedResource;
                }
                if (componentType != null && configuration != null && (componentTypeFromDiagram = graph.getPossibleObject(configuration, STR.Defines)) != null && componentType.equals(componentTypeFromDiagram)) {
                    return "Cannot instantiate user component within its own configuration.";
                }
                return symbol;
            }
        });
    }

    public void dragExit(DropTargetEvent dte, IDnDContext dp) {
    }

    public void dragOver(DropTargetDragEvent dtde, IDnDContext dp) {
    }

    private IElement tryPick(Point p) {
        Point2D canvas = this.transformUtil.controlToCanvas((Point2D)p, null);
        this.assertDependencies();
        PickRequest req = new PickRequest(canvas);
        req.pickPolicy = PickRequest.PickPolicy.PICK_INTERSECTING_OBJECTS;
        ArrayList picks = new ArrayList();
        this.pickContext.pick(this.diagram, req, picks);
        if (picks.size() == 1) {
            return (IElement)picks.iterator().next();
        }
        return null;
    }

    public void drop(DropTargetDropEvent dtde, final IDnDContext dp) {
        TimeLogger.resetTimeAndLog(((Object)((Object)this)).getClass(), (String)"drop");
        final IDiagram d = (IDiagram)this.getHint(DiagramHints.KEY_DIAGRAM);
        if (d == null) {
            return;
        }
        IElement pick = this.tryPick(dtde.getLocation());
        if (pick != null) {
            final ArrayList<WorkbenchSelectionElement> wses = new ArrayList<WorkbenchSelectionElement>();
            IDragItem[] iDragItemArray = (IDragItem[])dp.toArray();
            int n = iDragItemArray.length;
            int n2 = 0;
            while (n2 < n) {
                IDragItem i = iDragItemArray[n2];
                if (i instanceof WSEDragItem) {
                    wses.add((WorkbenchSelectionElement)((WSEDragItem)i).getObject());
                }
                ++n2;
            }
            Resource element = (Resource)ElementUtils.getData((IDiagram)d, (IElement)pick);
            if (element != null && !wses.isEmpty()) {
                try {
                    Session db = Simantics.getSession();
                    DiagramResource DIA = DiagramResource.getInstance((RequestProcessor)db);
                    final Variable function = (Variable)db.syncRequest((Read)new PossibleVariableProperty(element, DIA.symbolDropHandler));
                    if (function != null) {
                        db.syncRequest((Write)new WriteRequest(){

                            public void perform(WriteGraph graph) throws DatabaseException {
                                Simantics.invokeSCLWrite((WriteGraph)graph, (Variable)function, (Object)wses);
                            }
                        });
                        return;
                    }
                }
                catch (DatabaseException e) {
                    Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Invocation to custom symbolDropHandler for element " + element + " failed.", (Throwable)e));
                    return;
                }
            }
        }
        Runnable creator = new Runnable(){

            @Override
            public void run() {
                DiagramUtils.mutateDiagram((IDiagram)d, m -> {
                    IDragItem[] items;
                    IDragItem[] iDragItemArray = items = (IDragItem[])dp.toArray();
                    int n = items.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDragItem i = iDragItemArray[n2];
                        if (i instanceof ElementClassDragItem) {
                            ElementClassDragItem res = (ElementClassDragItem)i;
                            ElementClass ec = res.getElementClass();
                            Point2D pos = dp.getItemPosition(i);
                            if (!$assertionsDisabled && pos == null) {
                                throw new AssertionError();
                            }
                            IElement element = m.newElement(ec);
                            element.setHints(res.getHintContext().getHints());
                            PopulateElementDropParticipant.this.setupDroppedElement(element, pos);
                            dp.remove((Object)i);
                        }
                        ++n2;
                    }
                });
            }
        };
        this.selectNewDiagramContentAfter(d, this.partSite, creator);
        this.getContext().getContentContext().setDirty();
    }

    protected void selectNewDiagramContentAfter(IDiagram d, IWorkbenchPartSite activateSite, Runnable diagramModifier) {
        try {
            DiagramContentChanges changes;
            Set addedElements;
            Resource diagramResource = (Resource)d.getHint(DiagramModelHints.KEY_DIAGRAM_RESOURCE);
            DiagramContentTracker tracker = diagramResource == null ? null : DiagramContentTracker.start((ICanvasContext)this.getContext(), (RequestProcessor)Simantics.getSession(), (Resource)diagramResource);
            diagramModifier.run();
            if (tracker != null && !(addedElements = (changes = tracker.update()).pick(changes.elements, Change.ADDED)).isEmpty()) {
                new DiagramSelectionUpdater(this.getContext()).setNewSelection(0, addedElements).setOneshot(true).track();
                if (activateSite != null) {
                    WorkbenchUtils.activatePart((IWorkbenchPartSite)activateSite);
                }
            }
        }
        catch (DatabaseException e) {
            Activator.getDefault().getLog().log((IStatus)new Status(4, "org.simantics.modeling.ui", "Diagram content change tracking failed.", (Throwable)e));
        }
    }

    protected void setupDroppedElement(IElement element, Point2D dropPos) {
        IElement parent;
        ISnapAdvisor snapAdvisor = (ISnapAdvisor)this.getContext().getHintStack().getHint(DiagramHints.SNAP_ADVISOR);
        if (snapAdvisor != null) {
            snapAdvisor.snap(dropPos);
        }
        if ((parent = (IElement)element.getHint(ElementHints.KEY_PARENT_ELEMENT)) != null) {
            Point2D parentPos = ElementUtils.getPos((IElement)parent);
            Point2D.Double pos = new Point2D.Double(dropPos.getX() - parentPos.getX(), dropPos.getY() - parentPos.getY());
            ElementUtils.setPos((IElement)element, (Point2D)pos);
        } else {
            ElementUtils.setPos((IElement)element, (Point2D)dropPos);
        }
    }

    public void dropActionChanged(DropTargetDragEvent dtde, IDnDContext dp) {
        dtde.acceptDrag(1);
    }

    public int getAllowedOps() {
        return 1;
    }

    public double getPriority() {
        return 10.0;
    }

    private static class PossibleVariableProperty
    extends ResourceRead2<Variable> {
        public PossibleVariableProperty(Resource entity, Resource property) {
            super(entity, property);
        }

        public Variable perform(ReadGraph graph) throws DatabaseException {
            return Variables.tryGetProperty((ReadGraph)graph, (Resource)this.resource, (Resource)this.resource2);
        }
    }
}

