/*******************************************************************************
 * Copyright (c) 2012 Association for Decentralized Information Management in
 * Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.sharedontology.wizard;

import java.io.File;
import java.util.Deque;

import org.simantics.db.management.ISessionContext;
import org.simantics.modeling.ModelingUtils.LibraryInfo;
import org.simantics.project.IProject;

/**
 * @author Tuukka Lehtonen
 */
public class ExportPlan {


	
    // Input
    ISessionContext sessionContext;
    IProject        project;
    Object          selection;
    Deque<String>   recentLocations;

    // Output
    LibraryInfo     model;
    File            exportLocation;

    /**
     * <code>true</code> if the model should be overwritten without a warning.
     */
    boolean         overwrite;
    boolean         includeDependencies;
    boolean         tgAndPgraph;

    ExportPlan(ISessionContext sessionContext, Deque<String> recentLocations) {
        this.sessionContext = sessionContext;
        this.recentLocations = recentLocations;
    }

}