/*******************************************************************************
 * Copyright (c) 2017 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     Semantum Oy - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.scl.scriptEditor;

import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.contexts.IContextService;
import org.simantics.scl.ui.editor.SCLSourceViewerConfigurationNew;
import org.simantics.scl.ui.editor2.SCLModuleEditor2;

/**
 * @author Tuukka Lehtonen
 * @since 1.31.0
 */
public class SCLScriptEditor extends SCLModuleEditor2 {

    public SCLScriptEditor() {
        super();
        setDocumentProvider(new SCLScriptEditorDocumentProvider((SCLSourceViewerConfigurationNew) getSourceViewerConfiguration()));
    }

    @Override
    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        getSite().getService(IContextService.class).activateContext("org.simantics.modeling.ui.scl.scriptEditor.context");
    }

}
