package org.simantics.modeling.ui.scl.imports;

import java.util.ArrayList;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.simantics.scl.compiler.commands.CommandSessionImportEntry;
import org.simantics.scl.ui.imports.ImportModulesAction;

public class OntologyImportModulesAction extends ImportModulesAction {
    
    public static final OntologyImportModulesAction INSTANCE = new OntologyImportModulesAction();
            
    public OntologyImportModulesAction() {
        super("Add ontology", 10.0);
    }

    @Override
    public boolean editImports(Shell shell, ArrayList<CommandSessionImportEntry> imports) {
        ModuleSelectionDialog dialog = new ModuleSelectionDialog(shell, OntologiesQuery.INSTANCE);
        if(dialog.open() == Dialog.OK) {
            for(Object r : dialog.getResult()) {
                String uri = (String)r;
                new CommandSessionImportEntry(uri, getDefaultLocalName(uri), true).addTo(imports);
            }
            return true;
        }
        else
            return false;
    }
    
    public String getDefaultLocalName(String ontologyUri) {
        if(ontologyUri.contains("/Layer0-"))
            return "L0";
        if(ontologyUri.contains("/Structural-"))
            return "STR";
        if(ontologyUri.contains("/Modeling-"))
            return "MOD";
        return "";
    }

}
