/*******************************************************************************
 * Copyright (c) 2007, 2012 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.property;

import java.util.Collection;

import org.eclipse.core.expressions.PropertyTester;
import org.simantics.DatabaseJob;
import org.simantics.Simantics;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.Session;
import org.simantics.db.common.request.UniqueRead;
import org.simantics.db.common.utils.RequestUtil;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.request.ActiveModels;
import org.simantics.scl.reflection.OntologyVersions;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.ui.ErrorLogger;

/**
 * @author Tuukka Lehtonen
 */
public class ModelPropertyTester extends PropertyTester {

    /**
     * Tests if the received object within the model browser tree node is an
     * instance of the class specified as the argument.
     */
    private static final String HAS_ACTIVE_MODELS_OF_TYPE = "hasActiveModelsOfType";

    @Override
    public boolean test(final Object receiver, final String property, final Object[] args, final Object expectedValue) {
        try {
            if (HAS_ACTIVE_MODELS_OF_TYPE.equals(property)) {
                if (args.length == 0)
                    return false;

                Session session = Simantics.peekSession();
                final Resource project = Simantics.peekProjectResource();
                if (session != null && project != null) {
                    if (DatabaseJob.inProgress())
                        return false;

                    return RequestUtil.trySyncRequest(
                            session,
                            SimanticsUI.UI_THREAD_REQUEST_START_TIMEOUT,
                            SimanticsUI.UI_THREAD_REQUEST_EXECUTION_TIMEOUT,
                            false,
                            new UniqueRead<Boolean>() {
                        @Override
                        public Boolean perform(ReadGraph graph)
                                throws DatabaseException {
                            Resource type = graph.getPossibleResource( OntologyVersions.getInstance().currentVersion((String) args[0]) );
                            if (type == null)
                                return false;

                            Collection<Resource> activeModels = graph.syncRequest(new ActiveModels(project));
                            for (Resource activeModel : activeModels)
                                if (graph.isInstanceOf(activeModel, type))
                                    return true;
                            return false;
                        }
                    });
                }
            }
        } catch (DatabaseException | InterruptedException e) {
            ErrorLogger.defaultLogError(e);
        }
        return false;
    }

}
