/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser2.contributions;

import java.util.Collection;

import org.simantics.browsing.ui.graph.contributor.viewpoint.ViewpointContributor;
import org.simantics.db.ReadGraph;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.modelBrowser2.model.ImagesNode;
import org.simantics.structural.ui.modelBrowser.nodes.AbstractNode;
import org.simantics.structural.ui.modelBrowser.nodes.ModelNode;
import org.simantics.utils.DataContainer;

public class ModelImages extends ViewpointContributor<ModelNode> {

    @Override
    public Collection<?> getContribution(ReadGraph graph, ModelNode model) throws DatabaseException {
        return new DataContainer<AbstractNode>(new ImagesNode(model.resource));
    }

    @Override
    public String getViewpointId() {
        return "Standard";
    }

}
