/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.model;

import java.util.ArrayList;
import java.util.Collection;

import org.eclipse.jface.resource.ImageDescriptor;
import org.simantics.db.ReadGraph;
import org.simantics.db.Resource;
import org.simantics.db.exception.DatabaseException;
import org.simantics.modeling.ui.Activator;
import org.simantics.structural.stubs.StructuralResource2;
import org.simantics.structural2.utils.StructuralUtils;

@Deprecated
public class Interface extends Node {
	
	Resource instance; // may be null
	boolean isLeaf;
	
	public Interface(Resource resource, Resource instance, boolean isLeaf) {
		super(resource);
		this.instance = instance;
		this.isLeaf = isLeaf;
	}

	@Override
	public Collection<?> getChildren(ReadGraph g) throws DatabaseException {
		Collection<Resource> resources = 
		        StructuralUtils.getPropertyRelations(g, resource);
		Collection<INode> nodes = new ArrayList<INode>(resources.size());
		StructuralResource2 sr = StructuralResource2.getInstance(g);
		for(Resource r : resources) {
			if (g.hasStatement(resource, sr.Binds))
				nodes.add(new Parameter(g, r, instance, isLeaf));
		}
		return nodes;
	}

	@Override
	public ImageDescriptor getImage(ReadGraph g) {
		return Activator.INTERFACE_ICON;
	}
	
	@Override
	public String getLabel(ReadGraph g) throws DatabaseException {
		return "Interface [" + getChildren(g).size() + "]";
	}
	
	@Override
	public boolean equals(Object obj) {
		if(this == obj)
			return true;
		if(obj == null)
			return false;
		if(!getClass().equals(obj.getClass()))
			return false;
		Interface other = (Interface)obj;
		return resource.equals(other.resource)
			&& (instance == null ? other.instance==null : instance.equals(other.instance))
			&& isLeaf == other.isLeaf;
	}
	
	@Override
	public int hashCode() {
		return (getClass().hashCode()*31 + (instance == null ? 0 : instance.hashCode()))*31 + resource.hashCode();
	}

}
