/*******************************************************************************
 * Copyright (c) 2007, 2010 Association for Decentralized Information Management
 * in Industry THTH ry.
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License v1.0
 * which accompanies this distribution, and is available at
 * http://www.eclipse.org/legal/epl-v10.html
 *
 * Contributors:
 *     VTT Technical Research Centre of Finland - initial API and implementation
 *******************************************************************************/
package org.simantics.modeling.ui.modelBrowser.handlers;

import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;
import org.simantics.db.Resource;
import org.simantics.db.WriteGraph;
import org.simantics.db.common.request.WriteRequest;
import org.simantics.db.exception.DatabaseException;
import org.simantics.db.layer0.SelectionHints;
import org.simantics.db.layer0.adapter.InstanceFactory;
import org.simantics.simulation.ontology.SimulationResource;
import org.simantics.spreadsheet.resource.SpreadsheetResource;
import org.simantics.ui.SimanticsUI;
import org.simantics.utils.datastructures.ArrayMap;
import org.simantics.utils.ui.ISelectionUtils;

public class NewSpreadsheetHandler extends AbstractHandler {

    @Override
    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getCurrentSelection(event);
        final Resource container = ISelectionUtils.getSinglePossibleKey(selection, SelectionHints.KEY_MAIN, Resource.class);
        if (container == null)
            return null;

        SimanticsUI.getSession().asyncRequest(new WriteRequest() {
            @Override
            public void perform(WriteGraph graph) throws DatabaseException {
                SimulationResource SIMU = SimulationResource.getInstance(graph);
                SpreadsheetResource ssr = SpreadsheetResource.getInstance(graph);
                Resource configuration = graph.getPossibleObject(container, SIMU.HasConfiguration);
                if (configuration == null)
                    return;
                InstanceFactory sheetFactory = graph.adapt(ssr.Spreadsheet, InstanceFactory.class);
                graph.syncRequest(sheetFactory.create(graph, ArrayMap.keys("composite").values(configuration), ssr.ForCompositeTemplate));
            }
        });

        return null;
    }

}
